/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.common.xml.FullCustomerConverter;

@XStreamAlias(value="competition")
@Domain
public class Competition {
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private String name;
    private String description;
    @XStreamAsAttribute
    private int timeslotLength;
    @XStreamAsAttribute
    private int bootstrapTimeslotCount;
    @XStreamAsAttribute
    private int minimumTimeslotCount;
    @XStreamAsAttribute
    private int expectedTimeslotCount;
    @XStreamAsAttribute
    private int timeslotsOpen;
    @XStreamAsAttribute
    private int deactivateTimeslotsAhead;
    @XStreamAsAttribute
    private Instant simulationBaseTime;
    @XStreamAsAttribute
    private long simulationRate;
    @XStreamAsAttribute
    private long simulationModulo;
    @XStreamImplicit(itemFieldName="broker")
    private ArrayList<String> brokers;
    @XStreamImplicit(itemFieldName="customer")
    @XStreamConverter(value=FullCustomerConverter.class)
    private ArrayList<CustomerInfo> customers;
    private static Competition theCompetition;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public static Competition newInstance(String name) {
        Competition result;
        theCompetition = result = new Competition(name);
        return result;
    }

    public static Competition currentCompetition() {
        return theCompetition;
    }

    private Competition(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        this.id = IdGenerator.createId();
        this.name = "default";
        this.description = "";
        this.timeslotLength = 60;
        this.bootstrapTimeslotCount = 336;
        this.minimumTimeslotCount = 480;
        this.expectedTimeslotCount = 600;
        this.timeslotsOpen = 24;
        this.deactivateTimeslotsAhead = 1;
        this.simulationBaseTime = new DateTime(2010, 6, 21, 0, 0, 0, 0, DateTimeZone.UTC).toInstant();
        this.simulationRate = 720L;
        this.simulationModulo = 3600000L;
        this.name = name;
        this.brokers = new ArrayList();
        this.customers = new ArrayList();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withDescription(String string) {
        void description;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        this.description = description;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimeslotLength() {
        return this.timeslotLength;
    }

    public long getTimeslotDuration() {
        return (long)this.timeslotLength * 60000L;
    }

    public int computeTimeslotIndex(Instant time) {
        return (int)(time.getMillis() / this.getTimeslotDuration());
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withTimeslotLength(int n) {
        void timeslotLength;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.timeslotLength = timeslotLength;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getMinimumTimeslotCount() {
        return this.minimumTimeslotCount;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withMinimumTimeslotCount(int n) {
        void minimumTimeslotCount;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.minimumTimeslotCount = minimumTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getBootstrapTimeslotCount() {
        return this.bootstrapTimeslotCount;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withBootstrapTimeslotCount(int n) {
        void bootstrapTimeslotCount;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.bootstrapTimeslotCount = bootstrapTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getExpectedTimeslotCount() {
        return this.expectedTimeslotCount;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withExpectedTimeslotCount(int n) {
        void expectedTimeslotCount;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.expectedTimeslotCount = expectedTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimeslotsOpen() {
        return this.timeslotsOpen;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withTimeslotsOpen(int n) {
        void timeslotsOpen;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.timeslotsOpen = timeslotsOpen;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getDeactivateTimeslotsAhead() {
        return this.deactivateTimeslotsAhead;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withDeactivateTimeslotsAhead(int n) {
        void deactivateTimeslotsAhead;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.deactivateTimeslotsAhead = deactivateTimeslotsAhead;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public Instant getSimulationBaseTime() {
        return this.simulationBaseTime;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withSimulationBaseTime(Instant instant) {
        void simulationBaseTime;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)instant2);
        this.simulationBaseTime = simulationBaseTime;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public long getSimulationRate() {
        return this.simulationRate;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withSimulationRate(long l) {
        void simulationRate;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        this.simulationRate = simulationRate;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public long getSimulationModulo() {
        return this.simulationModulo;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition withSimulationModulo(long l) {
        void simulationModulo;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        this.simulationModulo = simulationModulo;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public List<String> getBrokers() {
        return this.brokers;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition addBroker(String string) {
        void brokerUsername;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
        this.brokers.add((String)brokerUsername);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public List<CustomerInfo> getCustomers() {
        return this.customers;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Competition addCustomer(CustomerInfo customerInfo) {
        void customer;
        CustomerInfo customerInfo2 = customerInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)customerInfo2);
        this.customers.add((CustomerInfo)customer);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public void update(Competition template) {
        this.withBootstrapTimeslotCount(template.getBootstrapTimeslotCount());
        this.withDeactivateTimeslotsAhead(template.getDeactivateTimeslotsAhead());
        this.withSimulationBaseTime(template.getSimulationBaseTime());
        this.withSimulationModulo(template.getSimulationModulo());
        this.withTimeslotLength(template.getTimeslotLength());
        this.withTimeslotsOpen(template.getTimeslotsOpen());
    }

    public String toString() {
        return this.name;
    }

    static {
        Factory factory = new Factory("Competition.java", Class.forName("org.powertac.common.Competition"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("2", "org.powertac.common.Competition", "java.lang.String:", "name:", ""), 133);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDescription", "org.powertac.common.Competition", "java.lang.String:", "description:", "", "org.powertac.common.Competition"), 163);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationModulo", "org.powertac.common.Competition", "long:", "simulationModulo:", "", "org.powertac.common.Competition"), 358);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBroker", "org.powertac.common.Competition", "java.lang.String:", "brokerUsername:", "", "org.powertac.common.Competition"), 377);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCustomer", "org.powertac.common.Competition", "org.powertac.common.CustomerInfo:", "customer:", "", "org.powertac.common.Competition"), 397);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimeslotLength", "org.powertac.common.Competition", "int:", "timeslotLength:", "", "org.powertac.common.Competition"), 198);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinimumTimeslotCount", "org.powertac.common.Competition", "int:", "minimumTimeslotCount:", "", "org.powertac.common.Competition"), 217);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withBootstrapTimeslotCount", "org.powertac.common.Competition", "int:", "bootstrapTimeslotCount:", "", "org.powertac.common.Competition"), 236);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withExpectedTimeslotCount", "org.powertac.common.Competition", "int:", "expectedTimeslotCount:", "", "org.powertac.common.Competition"), 254);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimeslotsOpen", "org.powertac.common.Competition", "int:", "timeslotsOpen:", "", "org.powertac.common.Competition"), 272);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDeactivateTimeslotsAhead", "org.powertac.common.Competition", "int:", "deactivateTimeslotsAhead:", "", "org.powertac.common.Competition"), 292);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationBaseTime", "org.powertac.common.Competition", "org.joda.time.Instant:", "simulationBaseTime:", "", "org.powertac.common.Competition"), 316);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationRate", "org.powertac.common.Competition", "long:", "simulationRate:", "", "org.powertac.common.Competition"), 335);
    }
}

