/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@XStreamAlias(value="plugin-config")
@Domain
public class PluginConfig {
    private static Logger log;
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private String roleName;
    @XStreamAsAttribute
    private String name;
    @XStreamOmitField
    private boolean privileged;
    private TreeMap<String, String> configuration;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        Factory factory = new Factory("PluginConfig.java", Class.forName("org.powertac.common.PluginConfig"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.PluginConfig", "java.lang.String:java.lang.String:", "role:name:", ""), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "asPrivileged", "org.powertac.common.PluginConfig", "", "", "", "org.powertac.common.PluginConfig"), 97);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addConfiguration", "org.powertac.common.PluginConfig", "java.lang.String:java.lang.String:", "name:value:", "", "org.powertac.common.PluginConfig"), 141);
        log = Logger.getLogger((String)PluginConfig.class.getName());
    }

    public PluginConfig(String role, String name) {
        String string = role;
        String string2 = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        this.id = IdGenerator.createId();
        this.name = "";
        this.privileged = false;
        this.roleName = role;
        this.name = name;
        this.configuration = new TreeMap();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    @StateChange
    public PluginConfig asPrivileged() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        this.privileged = true;
        PluginConfig pluginConfig = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return pluginConfig;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public String getConfigurationValue(String key) {
        return this.configuration.get(key);
    }

    public boolean update(PluginConfig replacement) {
        if (!this.roleName.equals(replacement.getRoleName()) || !this.name.equals(replacement.getName())) {
            log.error((Object)("replacement match failed: ours=[" + this.roleName + "," + this.name + "], theirs=[" + replacement.getRoleName() + "," + replacement.getName() + "]"));
            return false;
        }
        Map<String, String> rmap = replacement.getConfiguration();
        for (String key : rmap.keySet()) {
            this.addConfiguration(key, rmap.get(key));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public PluginConfig addConfiguration(String string, String string2) {
        void value;
        void name;
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string3, (Object)string4);
        this.configuration.put((String)name, (String)value);
        PluginConfig pluginConfig = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return pluginConfig;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PluginConfig:").append(this.roleName).append(":");
        sb.append(this.name).append("[");
        String delimiter = "";
        for (String key : this.configuration.keySet()) {
            sb.append(delimiter).append(key).append(":").append(this.configuration.get(key));
            delimiter = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    public Integer getIntegerValue(String name, Integer defaultValue) {
        String value = this.getConfigurationValue(name);
        Integer number = null;
        if (value != null) {
            number = Integer.parseInt(value);
        }
        if (value == null || number == null) {
            log.warn((Object)("parameter " + name + " not given in config"));
            return defaultValue;
        }
        return number;
    }

    public Double getDoubleValue(String name, Double defaultValue) {
        String value = this.getConfigurationValue(name);
        Double number = null;
        if (value != null) {
            number = Double.parseDouble(value);
        }
        if (value == null || number == null) {
            log.warn((Object)("parameter " + name + " not given in config"));
            return defaultValue;
        }
        return number;
    }
}

