/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.Tariff;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.spring.SpringApplicationContext;

public class TariffSubscription {
    private static Logger log = Logger.getLogger((String)TariffSubscription.class.getName());
    long id = IdGenerator.createId();
    private TimeService timeService;
    private Accounting accountingService;
    private TariffMarket tariffMarketService;
    private CustomerInfo customer;
    private Tariff tariff;
    private int customersCommitted = 0;
    private List<ExpirationRecord> expirations;
    private double totalUsage = 0.0;

    public TariffSubscription(CustomerInfo customer, Tariff tariff) {
        this.customer = customer;
        this.tariff = tariff;
        this.expirations = new ArrayList<ExpirationRecord>();
        this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        this.accountingService = (Accounting)SpringApplicationContext.getBean("accountingService");
        this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean("tariffMarketService");
    }

    public long getId() {
        return this.id;
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public Tariff getTariff() {
        return this.tariff;
    }

    public int getCustomersCommitted() {
        return this.customersCommitted;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    public void subscribe(int customerCount) {
        this.customersCommitted += customerCount;
        long minDuration = this.tariff.getMinDuration();
        Instant start = this.timeService.truncateInstant(this.timeService.getCurrentTime(), 86400000L);
        if (this.expirations.size() > 0 && this.expirations.get(this.expirations.size() - 1).getHorizon() == start.getMillis() + minDuration) {
            this.expirations.get(this.expirations.size() - 1).updateCount(customerCount);
        } else {
            this.expirations.add(new ExpirationRecord(start.getMillis() + minDuration, customerCount));
        }
        if (this.tariff.getSignupPayment() != 0.0) {
            log.debug((Object)("signup bonus: " + customerCount + " customers, total = " + (double)customerCount * this.tariff.getSignupPayment()));
        }
        this.accountingService.addTariffTransaction(TariffTransaction.Type.SIGNUP, this.tariff, this.customer, customerCount, 0.0, (double)customerCount * -this.tariff.getSignupPayment());
    }

    public void unsubscribe(int customerCount) {
        customerCount = Math.min(customerCount, this.customersCommitted);
        int freeAgentCount = this.getExpiredCustomerCount();
        int penaltyCount = Math.max(customerCount - freeAgentCount, 0);
        int expCount = customerCount;
        while (expCount > 0 && this.expirations.get(0) != null) {
            int cec = this.expirations.get(0).getCount();
            if (cec <= expCount) {
                expCount -= cec;
                this.expirations.remove(0);
                continue;
            }
            this.expirations.get(0).updateCount(-expCount);
            expCount = 0;
        }
        this.customersCommitted -= customerCount;
        if (this.tariff.getEarlyWithdrawPayment() != 0.0 && penaltyCount > 0) {
            this.accountingService.addTariffTransaction(TariffTransaction.Type.WITHDRAW, this.tariff, this.customer, customerCount, 0.0, (double)penaltyCount * -this.tariff.getEarlyWithdrawPayment());
        }
    }

    public TariffSubscription handleRevokedTariff() {
        if (!this.tariff.isRevoked()) {
            log.warn((Object)("Tariff " + this.tariff.getId() + " is not revoked."));
            return this;
        }
        Tariff newTariff = this.tariff.getIsSupersededBy();
        if (newTariff == null) {
            newTariff = this.tariffMarketService.getDefaultTariff(this.tariff.getTariffSpec().getPowerType());
        }
        TariffSubscription result = this.tariffMarketService.subscribeToTariff(newTariff, this.customer, this.customersCommitted);
        log.info((Object)("Tariff " + this.tariff.getId() + " superseded by " + newTariff.getId() + " for " + this.customersCommitted + "customers"));
        this.customersCommitted = 0;
        return result;
    }

    public void usePower(double kWh) {
        log.info((Object)("usePower " + kWh + ", customer=" + this.customer.getName()));
        if (this.customer == null) {
            log.error((Object)("null customerInfo for customer " + this.customer.getId()));
        }
        TariffTransaction.Type txType = kWh < 0.0 ? TariffTransaction.Type.PRODUCE : TariffTransaction.Type.CONSUME;
        this.accountingService.addTariffTransaction(txType, this.tariff, this.customer, this.customersCommitted, -kWh, (double)this.customersCommitted * -this.tariff.getUsageCharge(kWh / (double)this.customersCommitted, this.totalUsage, true));
        if (this.timeService.getHourOfDay() == 0) {
            this.totalUsage = 0.0;
        }
        this.totalUsage += kWh / (double)this.customersCommitted;
        if (this.tariff.getPeriodicPayment() != 0.0) {
            this.accountingService.addTariffTransaction(TariffTransaction.Type.PERIODIC, this.tariff, this.customer, this.customersCommitted, 0.0, (double)this.customersCommitted * -this.tariff.getPeriodicPayment() / 24.0);
        }
    }

    public int getExpiredCustomerCount() {
        int cc = 0;
        Instant today = this.timeService.truncateInstant(this.timeService.getCurrentTime(), 86400000L);
        for (ExpirationRecord exp : this.expirations) {
            if (exp.getHorizon() > today.getMillis()) continue;
            cc += exp.getCount();
        }
        return cc;
    }

    private class ExpirationRecord {
        private long horizon;
        private int count;

        ExpirationRecord(long horizon, int count) {
            this.horizon = horizon;
            this.count = count;
        }

        long getHorizon() {
            return this.horizon;
        }

        int getCount() {
            return this.count;
        }

        int updateCount(int increment) {
            this.count += increment;
            return this.count;
        }
    }
}

