/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.BrokerTransaction;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;
import org.powertac.common.xml.CustomerConverter;
import org.powertac.common.xml.TariffSpecificationConverter;

@XStreamAlias(value="tariff-tx")
@Domain
public class TariffTransaction
extends BrokerTransaction {
    @XStreamAsAttribute
    private Type txType;
    @XStreamConverter(value=CustomerConverter.class)
    private CustomerInfo customerInfo;
    @XStreamAsAttribute
    private int customerCount;
    @XStreamAsAttribute
    private double kWh;
    @XStreamAsAttribute
    private double charge;
    @XStreamConverter(value=TariffSpecificationConverter.class)
    private TariffSpecification tariffSpec;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public TariffTransaction(Broker broker, Instant when, Type txType, TariffSpecification spec, CustomerInfo customer, int customerCount, double kWh, double charge) {
        super(when, broker);
        Broker broker2 = broker;
        Instant instant = when;
        Type type = txType;
        TariffSpecification tariffSpecification = spec;
        CustomerInfo customerInfo = customer;
        int n = customerCount;
        double d = kWh;
        double d2 = charge;
        Object[] objectArray = new Object[]{broker2, instant, type, tariffSpecification, customerInfo, Conversions.intObject((int)n), Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        this.txType = Type.CONSUME;
        this.customerCount = 0;
        this.kWh = 0.0;
        this.charge = 0.0;
        this.txType = txType;
        this.tariffSpec = spec;
        this.customerInfo = customer;
        this.customerCount = customerCount;
        this.kWh = kWh;
        this.charge = charge;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public Type getTxType() {
        return this.txType;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    public int getCustomerCount() {
        return this.customerCount;
    }

    public double getKWh() {
        return this.kWh;
    }

    public double getCharge() {
        return this.charge;
    }

    public TariffSpecification getTariffSpec() {
        return this.tariffSpec;
    }

    public String toString() {
        return "TariffTx: customer" + this.customerInfo.getId() + " at " + Competition.currentCompetition().computeTimeslotIndex(this.postedTime) + ", " + (Object)((Object)this.txType) + ": " + this.kWh + "@" + this.charge;
    }

    static {
        Factory factory = new Factory("TariffTransaction.java", Class.forName("org.powertac.common.TariffTransaction"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.TariffTransaction", "org.powertac.common.Broker:org.joda.time.Instant:org.powertac.common.TariffTransaction$Type:org.powertac.common.TariffSpecification:org.powertac.common.CustomerInfo:int:double:double:", "broker:when:txType:spec:customer:customerCount:kWh:charge:", ""), 75);
    }

    public static enum Type {
        PUBLISH,
        PRODUCE,
        CONSUME,
        PERIODIC,
        SIGNUP,
        WITHDRAW,
        REVOKE;

    }
}

