/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractDateTime;
import org.powertac.common.TimedAction;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(value="singleton")
@Service
public class TimeService {
    private static Logger log;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    private long base;
    private long start = new DateTime(2036, 12, 31, 23, 59, 0, 0, DateTimeZone.UTC).getMillis();
    private long rate = 720L;
    private long modulo = 3600000L;
    private boolean busy = false;
    private TreeSet<SimulationAction> actions;
    private Instant currentTime;
    private DateTime currentDateTime;
    private static int index;
    private int id;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("TimeService.java", Class.forName("org.powertac.common.TimeService"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCurrentTime", "org.powertac.common.TimeService", "org.joda.time.Instant:", "time:", "", "void"), 258);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "setCurrentTime", "org.powertac.common.TimeService", "org.joda.time.base.AbstractDateTime:", "time:", "", "void"), 269);
        log = Logger.getLogger((String)TimeService.class.getName());
        index = 0;
    }

    public TimeService() {
        this.id = index++;
    }

    public TimeService(long base, long start, long rate, long modulo) {
        this.base = base;
        this.start = start;
        this.rate = rate;
        this.modulo = modulo;
        this.id = index++;
    }

    public void init() {
        this.currentTime = new Instant(this.base - this.modulo);
        this.currentDateTime = new DateTime((Object)this.currentTime, DateTimeZone.UTC);
    }

    public void updateTime() {
        if (this.busy) {
            this.start += 3600000L / this.rate;
            return;
        }
        this.busy = true;
        long systemTime = new Instant().getMillis();
        if (systemTime >= this.start) {
            long raw = this.base + (systemTime - this.start) * this.rate;
            log.debug((Object)("ts" + this.id + " updateTime: sys=" + systemTime + ", simTime=" + this.currentTime));
            this.setCurrentTime(new Instant(raw - raw % this.modulo));
            this.runActions();
        }
        this.busy = false;
    }

    public Instant truncateInstant(Instant time, long mod) {
        long ms = time.getMillis();
        return new Instant(ms - ms % mod);
    }

    public void setClockParameters(long base, long rate, long modulo) {
        this.base = base;
        this.rate = rate;
        this.modulo = modulo;
    }

    public long getBase() {
        return this.base;
    }

    public Instant getBaseInstant() {
        return new Instant(this.base);
    }

    @Deprecated
    public void setBase(long value) {
        this.base = value;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getRate() {
        return this.rate;
    }

    @Deprecated
    public void setRate(long value) {
        this.rate = value;
    }

    public long getModulo() {
        return this.modulo;
    }

    @Deprecated
    public void setModulo(long value) {
        this.modulo = value;
    }

    public Instant getCurrentTime() {
        return this.currentTime;
    }

    public DateTime getCurrentDateTime() {
        return this.currentDateTime;
    }

    public int getHourOfDay() {
        return this.currentDateTime.getHourOfDay();
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setCurrentTime(Instant instant) {
        void time;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)instant2);
        log.debug((Object)("ts" + this.id + " setCurrentTime to " + time.toString()));
        this.currentTime = time;
        this.currentDateTime = new DateTime((Object)time, DateTimeZone.UTC);
        StateLogging.aspectOf().setstate(joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    protected void setCurrentTime(AbstractDateTime abstractDateTime) {
        void time;
        AbstractDateTime abstractDateTime2 = abstractDateTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)abstractDateTime2);
        log.debug((Object)("ts" + this.id + " setCurrentTime to " + time.toString()));
        this.currentTime = new Instant((Object)time);
        this.currentDateTime = new DateTime((Object)time, DateTimeZone.UTC);
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public void addAction(Instant time, TimedAction act) {
        if (this.actions == null) {
            this.actions = new TreeSet();
        }
        this.actions.add(new SimulationAction(time, act));
    }

    /*
     * Unable to fully structure code
     */
    void runActions() {
        if (this.actions != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            act = this.actions.first();
            act.action.perform(this.currentTime);
            this.actions.remove(act);
lbl7:
            // 2 sources

            ** while (!this.actions.isEmpty() && !this.actions.first().atTime.isAfter((ReadableInstant)this.currentTime))
        }
lbl8:
        // 1 sources

    }

    class SimulationAction
    implements Comparable<SimulationAction> {
        public Instant atTime;
        TimedAction action;

        public SimulationAction(Instant time, TimedAction action) {
            this.atTime = time;
            this.action = action;
        }

        @Override
        public int compareTo(SimulationAction obj) {
            return this.atTime.compareTo((ReadableInstant)obj.atTime);
        }
    }
}

