/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.IdGenerator;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@XStreamAlias(value="slot")
@Domain
public class Timeslot {
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private int serialNumber;
    @XStreamOmitField
    private boolean enabled;
    private Instant startInstant;
    @XStreamOmitField
    private Timeslot previous;
    @XStreamOmitField
    private Timeslot next;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public Timeslot(int serial, Instant start, Timeslot previous) {
        int n = serial;
        Instant instant = start;
        Timeslot timeslot = previous;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), instant, timeslot};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        this.id = IdGenerator.createId();
        this.enabled = false;
        this.serialNumber = serial;
        this.startInstant = start;
        this.enabled = true;
        if (previous != null) {
            this.previous = previous;
            previous.next = this;
        }
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public long getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @StateChange
    public void enable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        this.enabled = true;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    @StateChange
    public void disable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        this.enabled = false;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public Instant getStartInstant() {
        return this.startInstant;
    }

    public Instant getEndInstant() {
        return this.startInstant.plus(Competition.currentCompetition().getTimeslotDuration());
    }

    public String toString() {
        return "timeslot " + this.serialNumber + ":" + this.startInstant.toString() + "(" + (this.enabled ? "enabled" : "disabled") + ")";
    }

    public Timeslot getNext() {
        return this.next;
    }

    public Timeslot getPrevious() {
        return this.previous;
    }

    static {
        Factory factory = new Factory("Timeslot.java", Class.forName("org.powertac.common.Timeslot"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Timeslot", "int:org.joda.time.Instant:org.powertac.common.Timeslot:", "serial:start:previous:", ""), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enable", "org.powertac.common.Timeslot", "", "", "", "void"), 111);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disable", "org.powertac.common.Timeslot", "", "", "", "void"), 117);
    }
}

