/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.List;
import org.powertac.common.PluginConfig;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Repository;

@Repository
public class PluginConfigRepo
implements DomainRepo {
    private ArrayList<PluginConfig> storage = new ArrayList();

    public PluginConfig makePluginConfig(String role, String name) {
        PluginConfig result = new PluginConfig(role, name);
        this.storage.add(result);
        return result;
    }

    public List<PluginConfig> list() {
        return this.storage;
    }

    public PluginConfig findByRoleName(String role) {
        for (PluginConfig config : this.storage) {
            if (!config.getRoleName().equals(role)) continue;
            return config;
        }
        return null;
    }

    public List<PluginConfig> findAllByRoleName(String role) {
        ArrayList<PluginConfig> result = new ArrayList<PluginConfig>();
        for (PluginConfig config : this.storage) {
            if (!config.getRoleName().equals(role)) continue;
            result.add(config);
        }
        return result;
    }

    public PluginConfig findMatching(PluginConfig match) {
        for (PluginConfig pic : this.findAllByRoleName(match.getRoleName())) {
            if (!match.getName().equals(pic.getName())) continue;
            return pic;
        }
        return null;
    }

    public List<PluginConfig> findAllPublic() {
        ArrayList<PluginConfig> result = new ArrayList<PluginConfig>();
        for (PluginConfig config : this.storage) {
            if (config.isPrivileged()) continue;
            result.add(config);
        }
        return result;
    }

    @Override
    public void recycle() {
        this.storage.clear();
    }
}

