/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.powertac.common.Rate;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSpecification;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Repository;

@Repository
public class TariffRepo
implements DomainRepo {
    private HashMap<Long, TariffSpecification> specs = new HashMap();
    private HashMap<Long, Tariff> tariffs = new HashMap();
    private HashMap<Long, Rate> rates = new HashMap();

    public synchronized void addSpecification(TariffSpecification spec) {
        this.specs.put(spec.getId(), spec);
        for (Rate r : spec.getRates()) {
            this.rates.put(r.getId(), r);
        }
    }

    public synchronized TariffSpecification findSpecificationById(long id) {
        return this.specs.get(id);
    }

    public synchronized void addTariff(Tariff tariff) {
        this.tariffs.put(tariff.getId(), tariff);
    }

    public synchronized Tariff findTariffById(long id) {
        return this.tariffs.get(id);
    }

    public synchronized List<Tariff> findAllTariffs() {
        return new ArrayList<Tariff>(this.tariffs.values());
    }

    public synchronized List<Tariff> findTariffsByState(Tariff.State state) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (state != tariff.getState()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized List<Tariff> findActiveTariffs(PowerType type) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (tariff.getPowerType() != type || tariff.isExpired() || tariff.isRevoked()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized Rate findRateById(long id) {
        return this.rates.get(id);
    }

    @Override
    public synchronized void recycle() {
        this.specs.clear();
        this.tariffs.clear();
        this.rates.clear();
    }
}

