/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.spring.SpringApplicationContext;

public class AbstractCustomer {
    protected static Logger log = Logger.getLogger((String)AbstractCustomer.class.getName());
    protected TariffMarket tariffMarketService;
    protected TariffSubscriptionRepo tariffSubscriptionRepo;
    protected CustomerRepo customerRepo;
    protected RandomSeedRepo randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean("randomSeedRepo");
    protected long custId;
    protected CustomerInfo customerInfo;
    protected double upperPowerCap = 100.0;
    protected double lowerPowerCap = 0.0;
    protected double carbonEmissionRate = 0.0;
    protected double windToPowerConversion = 0.0;
    protected double tempToPowerConversion = 0.0;
    protected double sunToPowerConversion = 0.0;
    protected RandomSeed rs1;

    public AbstractCustomer(CustomerInfo customer) {
        this.customerRepo = (CustomerRepo)SpringApplicationContext.getBean("customerRepo");
        this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean("tariffMarketService");
        this.tariffSubscriptionRepo = (TariffSubscriptionRepo)SpringApplicationContext.getBean("tariffSubscriptionRepo");
        this.custId = customer.getId();
        this.customerInfo = customer;
        this.rs1 = this.randomSeedRepo.getRandomSeed("AbstractCustomer", this.getCustId(), "TariffChooser");
        this.customerRepo.add(customer);
    }

    public String toString() {
        return this.customerInfo.getName();
    }

    public int getPopulation() {
        return this.customerInfo.getPopulation();
    }

    public long getCustId() {
        return this.custId;
    }

    public long getId() {
        return this.custId;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    public double getUpperPowerCap() {
        return this.upperPowerCap;
    }

    public double getLowerPowerCap() {
        return this.lowerPowerCap;
    }

    public double getCarbonEmissionRate() {
        return this.carbonEmissionRate;
    }

    public double getWindToPowerConversion() {
        return this.windToPowerConversion;
    }

    public double getTempToPowerConversion() {
        return this.tempToPowerConversion;
    }

    public double getSunToPowerConversion() {
        return this.sunToPowerConversion;
    }

    public void subscribeDefault() {
        for (PowerType type : this.customerInfo.getPowerTypes()) {
            if (this.tariffMarketService.getDefaultTariff(type) == null) {
                log.info((Object)("No default Subscription for type " + type.toString() + " for " + this.toString() + " to subscribe to."));
                continue;
            }
            this.tariffMarketService.subscribeToTariff(this.tariffMarketService.getDefaultTariff(type), this.customerInfo, this.getPopulation());
            log.info((Object)(String.valueOf(this.toString()) + " was subscribed to the default broker successfully."));
        }
    }

    public void subscribe(Tariff tariff, int customerCount) {
        this.tariffMarketService.subscribeToTariff(tariff, this.customerInfo, customerCount);
        log.info((Object)(String.valueOf(this.toString()) + ": " + customerCount + " were subscribed to tariff " + tariff.getId()));
    }

    public void unsubscribe(TariffSubscription subscription, int customerCount) {
        subscription.unsubscribe(customerCount);
        log.info((Object)(String.valueOf(this.toString()) + ": " + customerCount + " were unsubscribed from tariff " + subscription.getTariff().getId()));
    }

    public void consumePower() {
    }

    public void producePower() {
    }

    public void changeSubscription(Tariff tariff) {
        TariffSubscription ts = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(tariff, this.customerInfo);
        int populationCount = ts.getCustomersCommitted();
        this.unsubscribe(ts, populationCount);
        Tariff newTariff = this.selectTariff(tariff.getTariffSpec().getPowerType());
        this.subscribe(newTariff, populationCount);
    }

    public void changeSubscription(Tariff tariff, Tariff newTariff) {
        TariffSubscription ts = this.tariffSubscriptionRepo.getSubscription(this.customerInfo, tariff);
        int populationCount = ts.getCustomersCommitted();
        this.unsubscribe(ts, populationCount);
        this.subscribe(newTariff, populationCount);
    }

    public void changeSubscription(Tariff tariff, Tariff newTariff, int populationCount) {
        TariffSubscription ts = this.tariffSubscriptionRepo.getSubscription(this.customerInfo, tariff);
        this.unsubscribe(ts, populationCount);
        this.subscribe(newTariff, populationCount);
    }

    public Tariff selectTariff(PowerType powerType) {
        List<Object> available = new ArrayList();
        available = this.tariffMarketService.getActiveTariffList(powerType);
        int index = available.indexOf(this.tariffMarketService.getDefaultTariff(powerType));
        log.info((Object)("Index of Default Tariff: " + index));
        int ran = index;
        while (ran == index) {
            ran = (int)((double)available.size() * this.rs1.nextDouble());
        }
        Tariff result = (Tariff)available.get(ran);
        return result;
    }

    public void checkRevokedSubscriptions() {
        List<TariffSubscription> revoked = this.tariffSubscriptionRepo.getRevokedSubscriptionList(this.customerInfo);
        for (TariffSubscription revokedSubscription : revoked) {
            revokedSubscription.handleRevokedTariff();
        }
    }

    public void step() {
    }
}

