/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.powertac.common.Broker;
import org.powertac.common.HourlyCharge;
import org.powertac.common.Rate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TimeService;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
public class Tariff {
    private static Logger log;
    private TimeService timeService;
    private TariffRepo tariffRepo;
    private long specId;
    private TariffSpecification tariffSpec;
    private Broker broker;
    private State state;
    private Tariff isSupersededBy;
    double totalCost;
    double totalUsage;
    private Instant offerDate;
    private Instant expiration;
    private boolean isWeekly;
    private boolean analyzed;
    private HashMap<Long, Rate> rateIdMap;
    private List<Double> tiers;
    private Rate[][] rateMap;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("Tariff.java", Class.forName("org.powertac.common.Tariff"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Tariff", "org.powertac.common.TariffSpecification:", "spec:", ""), 115);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addHourlyCharge", "org.powertac.common.Tariff", "org.powertac.common.HourlyCharge:long:", "newCharge:rateId:", "", "boolean"), 176);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPeriodicPayment", "org.powertac.common.Tariff", "", "", "", "void"), 241);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpiration", "org.powertac.common.Tariff", "org.joda.time.Instant:", "newDate:", "", "void"), 353);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setState", "org.powertac.common.Tariff", "org.powertac.common.Tariff$State:", "newState:", "", "void"), 404);
        log = Logger.getLogger((String)Tariff.class.getName());
    }

    public Tariff(TariffSpecification spec) {
        TariffSpecification tariffSpecification = spec;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tariffSpecification);
        this.state = State.PENDING;
        this.totalCost = 0.0;
        this.totalUsage = 0.0;
        this.isWeekly = false;
        this.analyzed = false;
        this.tariffSpec = spec;
        this.specId = spec.getId();
        this.broker = spec.getBroker();
        this.expiration = spec.getExpiration();
        this.rateIdMap = new HashMap();
        for (Rate r : spec.getRates()) {
            this.rateIdMap.put(r.getId(), r);
        }
        this.tiers = new ArrayList<Double>();
        if (spec.getSupersedes() != null) {
            for (long supId : spec.getSupersedes()) {
                Tariff supersededTariff = this.tariffRepo.findTariffById(supId);
                if (supersededTariff == null) {
                    log.error((Object)("Superseded tariff " + supId + " not found"));
                    continue;
                }
                supersededTariff.isSupersededBy = this;
            }
        }
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public void init() {
        this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        this.tariffRepo = (TariffRepo)SpringApplicationContext.getBean("tariffRepo");
        if (this.timeService == null) {
            log.error((Object)"timeService not initialized!");
        }
        this.offerDate = this.timeService.getCurrentTime();
        this.tariffRepo.addTariff(this);
        this.analyze();
    }

    public TariffSpecification getTariffSpecification() {
        return this.tariffSpec;
    }

    public long getSpecId() {
        return this.specId;
    }

    public long getId() {
        return this.specId;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public boolean addHourlyCharge(HourlyCharge hourlyCharge, long l) {
        boolean bl;
        void rateId;
        HourlyCharge hourlyCharge2 = hourlyCharge;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)hourlyCharge2, (Object)Conversions.longObject((long)l2));
        Rate theRate = this.rateIdMap.get((long)rateId);
        if (theRate == null) {
            log.error((Object)("addHourlyCharge - no rate " + (long)rateId));
            bl = false;
        } else {
            void newCharge;
            bl = theRate.addHourlyCharge((HourlyCharge)newCharge);
        }
        StateLogging.aspectOf().setstate(joinPoint);
        return bl;
    }

    public double getRealizedPrice() {
        if (this.totalUsage == 0.0) {
            return 0.0;
        }
        return this.totalCost / this.totalUsage;
    }

    public long getMinDuration() {
        return this.tariffSpec.getMinDuration();
    }

    public PowerType getPowerType() {
        return this.tariffSpec.getPowerType();
    }

    public double getSignupPayment() {
        return this.tariffSpec.getSignupPayment();
    }

    public double getEarlyWithdrawPayment() {
        return this.tariffSpec.getEarlyWithdrawPayment();
    }

    public double getPeriodicPayment() {
        return this.tariffSpec.getPeriodicPayment();
    }

    @StateChange
    public void addPeriodicPayment() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getUsageCharge(double kwh, double cumulativeUsage, boolean recordUsage) {
        double amt = this.getUsageCharge(this.timeService.getCurrentTime(), kwh, cumulativeUsage);
        if (recordUsage) {
            this.totalUsage += kwh;
            this.totalCost += amt;
        }
        return amt;
    }

    public double getUsageCharge(Instant when, double kwh, double cumulativeUsage) {
        DateTime dt = new DateTime((Object)when, DateTimeZone.UTC);
        int di = dt.getHourOfDay();
        if (this.isWeekly) {
            di += 24 * (dt.getDayOfWeek() - 1);
        }
        if (this.tiers == null || this.tiers.size() < 1) {
            log.error((Object)("uninitialized tariff " + this.getId()));
            return 0.0;
        }
        if (this.tiers.size() == 1) {
            return kwh * this.rateValue(0, di, when);
        }
        double remainingAmount = kwh;
        double accumulatedAmount = cumulativeUsage;
        double result = 0.0;
        int ti = 0;
        while (remainingAmount > 0.0) {
            if (this.tiers.size() > ti + 1) {
                if (accumulatedAmount >= this.tiers.get(ti + 1)) {
                    log.debug((Object)("accumulatedAmount " + accumulatedAmount + " above threshold " + (ti + 1) + ":" + this.tiers.get(ti + 1)));
                    ++ti;
                    continue;
                }
                if (remainingAmount + accumulatedAmount > this.tiers.get(ti + 1)) {
                    double amt = this.tiers.get(ti + 1) - accumulatedAmount;
                    log.debug((Object)("split off " + amt + " below " + this.tiers.get(ti + 1)));
                    result += amt * this.rateValue(ti++, di, when);
                    remainingAmount -= amt;
                    accumulatedAmount += amt;
                    continue;
                }
                log.debug((Object)("amount " + remainingAmount + " fits in tier " + ti));
                result += remainingAmount * this.rateValue(ti, di, when);
                remainingAmount = 0.0;
                continue;
            }
            log.debug((Object)("remainder " + remainingAmount + " fits in top tier"));
            result += remainingAmount * this.rateValue(ti, di, when);
            remainingAmount = 0.0;
        }
        return result;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isExpired() {
        if (this.getExpiration() == null) {
            return false;
        }
        return !this.timeService.getCurrentTime().isBefore((ReadableInstant)this.getExpiration());
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setExpiration(Instant instant) {
        void newDate;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)instant2);
        this.expiration = newDate;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public Instant getOfferDate() {
        return this.offerDate;
    }

    public boolean isCovered() {
        int tier = 0;
        while (tier < this.tiers.size()) {
            int hour = 0;
            while (hour < (this.isWeekly ? 168 : 24)) {
                if (this.rateMap[tier][hour] == null) {
                    return false;
                }
                ++hour;
            }
            ++tier;
        }
        return true;
    }

    public TariffSpecification getTariffSpec() {
        return this.tariffSpec;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public State getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setState(State state) {
        void newState;
        State state2 = state;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)((Object)state2));
        this.state = newState;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public Tariff getIsSupersededBy() {
        return this.isSupersededBy;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    public boolean isWeekly() {
        return this.isWeekly;
    }

    public boolean isRevoked() {
        return this.state == State.KILLED;
    }

    private void analyze() {
        HashMap<Double, Integer> tierIndexMap = new HashMap<Double, Integer>();
        this.tiers.add(0.0);
        for (Rate rate : this.tariffSpec.getRates()) {
            if (rate.getWeeklyBegin() >= 0) {
                this.isWeekly = true;
            }
            if (!(rate.getTierThreshold() > 0.0)) continue;
            this.tiers.add(rate.getTierThreshold());
        }
        Collections.sort(this.tiers);
        log.info((Object)("tariff " + this.specId + ", tiers: " + this.tiers));
        int tidx = 0;
        Iterator<Object> iterator = this.tiers.iterator();
        while (iterator.hasNext()) {
            double threshold = iterator.next();
            tierIndexMap.put(threshold, tidx++);
        }
        TreeMap<Integer, Rate> annotatedRates = new TreeMap<Integer, Rate>();
        for (Rate rate : this.tariffSpec.getRates()) {
            int value = 0;
            if (rate.getDailyBegin() >= 0) {
                value = rate.getDailyBegin();
            }
            if (rate.getWeeklyBegin() >= 0) {
                value += rate.getWeeklyBegin() * 24;
            }
            if (rate.getTierThreshold() > 0.0) {
                value += (Integer)tierIndexMap.get(rate.getTierThreshold()) * 7 * 24;
            }
            log.debug((Object)("inserting " + value + ", " + rate.getId()));
            annotatedRates.put(value, rate);
        }
        this.rateMap = new Rate[tierIndexMap.size()][this.isWeekly ? 168 : 24];
        for (Map.Entry entry : annotatedRates.entrySet()) {
            int hour;
            Rate rate = (Rate)entry.getValue();
            int ti = (Integer)tierIndexMap.get(rate.getTierThreshold());
            int day1 = 0;
            int dayn = 0;
            if (this.isWeekly) {
                if (rate.getWeeklyBegin() >= 0) {
                    day1 = rate.getWeeklyBegin() - 1;
                    dayn = rate.getWeeklyBegin() - 1;
                } else {
                    dayn = 6;
                }
                if (rate.getWeeklyEnd() >= 0) {
                    dayn = rate.getWeeklyEnd() - 1;
                }
            }
            int hr1 = 0;
            int hrn = 23;
            if (rate.getDailyBegin() >= 0) {
                hr1 = rate.getDailyBegin();
                hrn = rate.getDailyEnd();
            }
            log.debug((Object)("day1=" + day1 + ", dayn=" + dayn + ", hr1=" + hr1 + ", hrn=" + hrn));
            int day = dayn < day1 ? 0 : day1;
            while (day <= dayn) {
                hour = hrn < hr1 ? 0 : hr1;
                while (hour <= hrn) {
                    this.rateMap[ti][hour + day * 24] = rate;
                    ++hour;
                }
                if (hrn < hr1) {
                    hour = hr1;
                    while (hour <= 23) {
                        this.rateMap[ti][hour + day * 24] = rate;
                        ++hour;
                    }
                }
                ++day;
            }
            if (dayn >= day1) continue;
            day = day1;
            while (day <= 6) {
                hour = hrn < hr1 ? 0 : hr1;
                while (hour <= hrn) {
                    this.rateMap[ti][hour + day * 24] = rate;
                    ++hour;
                }
                if (hrn < hr1) {
                    hour = hr1;
                    while (hour <= 23) {
                        this.rateMap[ti][hour + day * 24] = rate;
                        ++hour;
                    }
                }
                ++day;
            }
        }
        this.analyzed = true;
    }

    private double rateValue(int tierIndex, int timeIndex, Instant when) {
        Rate rate = this.rateMap[tierIndex][timeIndex];
        if (rate == null) {
            log.error((Object)("could not find rate for tier " + tierIndex + ", ti " + timeIndex));
            return 0.0;
        }
        return rate.getValue((AbstractInstant)when);
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public static enum State {
        PENDING,
        OFFERED,
        ACTIVE,
        WITHDRAWN,
        KILLED,
        INACTIVE;

    }
}

