/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.ReadableInstant;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecast;
import org.powertac.common.exceptions.PowerTacException;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WeatherForecastRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)WeatherForecastRepo.class.getName());
    private HashMap<Timeslot, WeatherForecast> indexedWeatherForecasts = new HashMap();
    private boolean hasRunOnce = false;
    @Autowired
    private TimeslotRepo timeslotRepo;

    public void add(WeatherForecast weather) {
        this.runOnce();
        this.indexedWeatherForecasts.put(weather.getCurrentTimeslot(), weather);
    }

    public WeatherForecast currentWeatherForecast() throws PowerTacException {
        if (!this.hasRunOnce) {
            log.error((Object)"Weather Service has yet to run, cannot retrieve report");
            throw new PowerTacException("Attempt to retrieve forecast before data available");
        }
        return this.indexedWeatherForecasts.get(this.timeslotRepo.currentTimeslot());
    }

    public List<WeatherForecast> allWeatherForecasts() {
        Timeslot current = this.timeslotRepo.currentTimeslot();
        ArrayList<WeatherForecast> issuedReports = new ArrayList<WeatherForecast>();
        for (WeatherForecast w : this.indexedWeatherForecasts.values()) {
            if (!w.getCurrentTimeslot().getStartInstant().isBefore((ReadableInstant)current.getStartInstant())) continue;
            issuedReports.add(w);
        }
        issuedReports.add(this.currentWeatherForecast());
        return issuedReports;
    }

    public int count() {
        return this.indexedWeatherForecasts.size();
    }

    public void runOnce() {
        this.hasRunOnce = true;
    }

    @Override
    public void recycle() {
        this.hasRunOnce = false;
        this.indexedWeatherForecasts.clear();
    }
}

