/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.Tariff;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.spring.SpringApplicationContext;

public class TariffSubscription {
    private static Logger log = Logger.getLogger((String)TariffSubscription.class.getName());
    long id = IdGenerator.createId();
    private TimeService timeService;
    private Accounting accountingService;
    private TariffMarket tariffMarketService;
    private CustomerInfo customer;
    private Tariff tariff;
    private int customersCommitted = 0;
    private List<ExpirationRecord> expirations;
    private double totalUsage = 0.0;
    private int pendingUnsubscribeCount = 0;
    double pendingCurtailmentRatio = 0.0;
    double curtailment = 0.0;
    double maxRemainingCurtailment = 0.0;

    public TariffSubscription(CustomerInfo customer, Tariff tariff) {
        this.customer = customer;
        this.tariff = tariff;
        this.expirations = new ArrayList<ExpirationRecord>();
        this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        this.accountingService = (Accounting)SpringApplicationContext.getBean("accountingService");
        this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean("tariffMarketService");
    }

    public long getId() {
        return this.id;
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public Tariff getTariff() {
        return this.tariff;
    }

    public int getCustomersCommitted() {
        return this.customersCommitted;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    public void subscribe(int customerCount) {
        this.customersCommitted += customerCount;
        long minDuration = this.tariff.getMinDuration();
        Instant start = this.timeService.truncateInstant(this.timeService.getCurrentTime(), 86400000L);
        if (this.expirations.size() > 0 && this.expirations.get(this.expirations.size() - 1).getHorizon() == start.getMillis() + minDuration) {
            this.expirations.get(this.expirations.size() - 1).updateCount(customerCount);
        } else {
            this.expirations.add(new ExpirationRecord(start.getMillis() + minDuration, customerCount));
        }
        if (this.tariff.getSignupPayment() != 0.0) {
            log.debug((Object)("signup bonus: " + customerCount + " customers, total = " + (double)customerCount * this.tariff.getSignupPayment()));
        }
        this.accountingService.addTariffTransaction(TariffTransaction.Type.SIGNUP, this.tariff, this.customer, customerCount, 0.0, (double)customerCount * -this.tariff.getSignupPayment());
    }

    public void unsubscribe(int customerCount) {
        this.tariffMarketService.subscribeToTariff(this.getTariff(), this.getCustomer(), -customerCount);
        this.pendingUnsubscribeCount += customerCount;
    }

    public void deferredUnsubscribe(int customerCount) {
        this.pendingUnsubscribeCount = 0;
        this.maxRemainingCurtailment = 0.0;
        customerCount = Math.min(customerCount, this.customersCommitted);
        int freeAgentCount = this.getExpiredCustomerCount();
        int penaltyCount = Math.max(customerCount - freeAgentCount, 0);
        int expCount = customerCount;
        while (expCount > 0 && this.expirations.get(0) != null) {
            int cec = this.expirations.get(0).getCount();
            if (cec <= expCount) {
                expCount -= cec;
                this.expirations.remove(0);
                continue;
            }
            this.expirations.get(0).updateCount(-expCount);
            expCount = 0;
        }
        this.customersCommitted -= customerCount;
        this.accountingService.addTariffTransaction(TariffTransaction.Type.WITHDRAW, this.tariff, this.customer, customerCount, 0.0, (double)penaltyCount * -this.tariff.getEarlyWithdrawPayment());
    }

    public void handleRevokedTariff() {
        if (!this.tariff.isRevoked()) {
            log.warn((Object)("Tariff " + this.tariff.getId() + " is not revoked."));
        }
        if (this.customersCommitted == 0) {
            return;
        }
        Tariff newTariff = this.tariff.getIsSupersededBy();
        if (newTariff == null) {
            newTariff = this.tariffMarketService.getDefaultTariff(this.tariff.getTariffSpec().getPowerType());
        }
        this.tariffMarketService.subscribeToTariff(this.tariff, this.customer, -this.customersCommitted);
        this.tariffMarketService.subscribeToTariff(newTariff, this.customer, this.customersCommitted);
        log.info((Object)("Tariff " + this.tariff.getId() + " superseded by " + newTariff.getId() + " for " + this.customersCommitted + "customers"));
    }

    public void usePower(double kwh) {
        double actualKwh = kwh - this.getCurtailedKwh(kwh, this.totalUsage);
        log.info((Object)("usePower " + kwh + ", actual " + actualKwh + ", customer=" + this.customer.getName()));
        TariffTransaction.Type txType = actualKwh < 0.0 ? TariffTransaction.Type.PRODUCE : TariffTransaction.Type.CONSUME;
        this.accountingService.addTariffTransaction(txType, this.tariff, this.customer, this.customersCommitted, -actualKwh, (double)this.customersCommitted * -this.tariff.getUsageCharge(actualKwh / (double)this.customersCommitted, this.totalUsage, true));
        if (this.timeService.getHourOfDay() == 0) {
            this.totalUsage = 0.0;
        }
        this.totalUsage += actualKwh / (double)this.customersCommitted;
        if (this.tariff.getPeriodicPayment() != 0.0) {
            this.accountingService.addTariffTransaction(TariffTransaction.Type.PERIODIC, this.tariff, this.customer, this.customersCommitted, 0.0, (double)this.customersCommitted * -this.tariff.getPeriodicPayment() / 24.0);
        }
    }

    public synchronized void postRatioControl(double ratio) {
        this.pendingCurtailmentRatio = ratio;
    }

    public synchronized void postBalancingControl(double kwh) {
        this.addCurtailment(kwh);
        TariffTransaction.Type txType = kwh > 0.0 ? TariffTransaction.Type.PRODUCE : TariffTransaction.Type.CONSUME;
        this.accountingService.addTariffTransaction(txType, this.tariff, this.customer, this.customersCommitted, kwh, (double)this.customersCommitted * this.tariff.getUsageCharge(kwh / (double)this.customersCommitted, this.totalUsage, true));
        this.totalUsage -= kwh / (double)this.customersCommitted;
    }

    public synchronized double getCurtailment() {
        double result = this.curtailment;
        this.curtailment = 0.0;
        return result;
    }

    public double getMaxRemainingCurtailment() {
        double result = this.maxRemainingCurtailment;
        if (this.pendingUnsubscribeCount == 0) {
            return result;
        }
        double ratio = (double)(this.customersCommitted - this.pendingUnsubscribeCount) / (double)this.customersCommitted;
        log.info((Object)("remaining curtailment reduced by " + ratio));
        return result * ratio;
    }

    double getCurtailedKwh(double proposedUsage, double cumulativeUsage) {
        double proposedCurtailment = proposedUsage * this.pendingCurtailmentRatio;
        this.maxRemainingCurtailment = this.tariff.getMaxCurtailment(proposedUsage, cumulativeUsage);
        double result = Math.min(proposedCurtailment, this.maxRemainingCurtailment);
        log.debug((Object)("proposedCurtailment=" + proposedCurtailment + ", maxCurtailment=" + this.maxRemainingCurtailment));
        this.pendingCurtailmentRatio = 0.0;
        this.curtailment += result;
        this.maxRemainingCurtailment -= result;
        return result;
    }

    void addCurtailment(double kwh) {
        this.curtailment += kwh;
    }

    public int getExpiredCustomerCount() {
        int cc = 0;
        Instant today = this.timeService.truncateInstant(this.timeService.getCurrentTime(), 86400000L);
        for (ExpirationRecord exp : this.expirations) {
            if (exp.getHorizon() > today.getMillis()) continue;
            cc += exp.getCount();
        }
        return cc;
    }

    private class ExpirationRecord {
        private long horizon;
        private int count;

        ExpirationRecord(long horizon, int count) {
            this.horizon = horizon;
            this.count = count;
        }

        long getHorizon() {
            return this.horizon;
        }

        int getCount() {
            return this.count;
        }

        int updateCount(int increment) {
            this.count += increment;
            return this.count;
        }
    }
}

