/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.ReadableInstant;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherReport;
import org.powertac.common.exceptions.PowerTacException;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WeatherReportRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)WeatherReportRepo.class.getName());
    private HashMap<Timeslot, WeatherReport> indexedWeatherReports = new HashMap();
    private boolean hasRunOnce = false;
    @Autowired
    private TimeslotRepo timeslotRepo;

    public void add(WeatherReport weather) {
        this.runOnce();
        this.indexedWeatherReports.put(weather.getCurrentTimeslot(), weather);
    }

    public WeatherReport currentWeatherReport() throws PowerTacException {
        if (!this.hasRunOnce) {
            log.error((Object)"Weather Service has yet to run, cannot retrieve report");
            throw new PowerTacException("Attempt to retrieve report before data available");
        }
        return this.indexedWeatherReports.get(this.timeslotRepo.currentTimeslot());
    }

    public List<WeatherReport> allWeatherReports() {
        Timeslot current = this.timeslotRepo.currentTimeslot();
        ArrayList<WeatherReport> issuedReports = new ArrayList<WeatherReport>();
        for (WeatherReport w : this.indexedWeatherReports.values()) {
            if (!w.getCurrentTimeslot().getStartInstant().isBefore((ReadableInstant)current.getStartInstant())) continue;
            issuedReports.add(w);
        }
        issuedReports.add(this.currentWeatherReport());
        return issuedReports;
    }

    public int count() {
        return this.indexedWeatherReports.size();
    }

    public void runOnce() {
        this.hasRunOnce = true;
    }

    @Override
    public void recycle() {
        this.hasRunOnce = false;
        this.indexedWeatherReports.clear();
    }
}

