/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Rate;
import org.powertac.common.TariffMessage;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain(fields={"broker", "powerType", "minDuration", "signupPayment", "earlyWithdrawPayment", "periodicPayment"})
@XStreamAlias(value="tariff-spec")
public class TariffSpecification
extends TariffMessage {
    private static Logger log;
    private Instant expiration;
    @XStreamAsAttribute
    private long minDuration;
    @XStreamAsAttribute
    private PowerType powerType;
    @XStreamAsAttribute
    private double signupPayment;
    @XStreamAsAttribute
    private double earlyWithdrawPayment;
    @XStreamAsAttribute
    private double periodicPayment;
    private List<Rate> rates;
    private List<Long> supersedes;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("TariffSpecification.java", Class.forName("org.powertac.common.TariffSpecification"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.TariffSpecification", "org.powertac.common.Broker:org.powertac.common.enumerations.PowerType:", "broker:powerType:", ""), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withExpiration", "org.powertac.common.TariffSpecification", "org.joda.time.Instant:", "expiration:", "", "org.powertac.common.TariffSpecification"), 110);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinDuration", "org.powertac.common.TariffSpecification", "long:", "minDuration:", "", "org.powertac.common.TariffSpecification"), 127);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSignupPayment", "org.powertac.common.TariffSpecification", "double:", "signupPayment:", "", "org.powertac.common.TariffSpecification"), 143);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withEarlyWithdrawPayment", "org.powertac.common.TariffSpecification", "double:", "earlyWithdrawPayment:", "", "org.powertac.common.TariffSpecification"), 160);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withPeriodicPayment", "org.powertac.common.TariffSpecification", "double:", "periodicPayment:", "", "org.powertac.common.TariffSpecification"), 176);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addRate", "org.powertac.common.TariffSpecification", "org.powertac.common.Rate:", "rate:", "", "org.powertac.common.TariffSpecification"), 201);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addSupersedes", "org.powertac.common.TariffSpecification", "long:", "specId:", "", "org.powertac.common.TariffSpecification"), 220);
        log = Logger.getLogger(TariffSpecification.class);
    }

    public TariffSpecification(Broker broker, PowerType powerType) {
        super(broker);
        Broker broker2 = broker;
        PowerType powerType2 = powerType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)broker2, (Object)powerType2);
        this.expiration = null;
        this.minDuration = 0L;
        this.powerType = PowerType.CONSUMPTION;
        this.signupPayment = 0.0;
        this.earlyWithdrawPayment = 0.0;
        this.periodicPayment = 0.0;
        this.broker = broker;
        this.powerType = powerType;
        this.rates = new ArrayList<Rate>();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public PowerType getPowerType() {
        return this.powerType;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public TariffSpecification withExpiration(Instant instant) {
        void expiration;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)instant2);
        this.expiration = expiration;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public long getMinDuration() {
        return this.minDuration;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public TariffSpecification withMinDuration(long l) {
        void minDuration;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        this.minDuration = minDuration;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public double getSignupPayment() {
        return this.signupPayment;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public TariffSpecification withSignupPayment(double d) {
        void signupPayment;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.signupPayment = signupPayment;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public double getEarlyWithdrawPayment() {
        return this.earlyWithdrawPayment;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public TariffSpecification withEarlyWithdrawPayment(double d) {
        void earlyWithdrawPayment;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.earlyWithdrawPayment = earlyWithdrawPayment;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public double getPeriodicPayment() {
        return this.periodicPayment;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public TariffSpecification withPeriodicPayment(double d) {
        void periodicPayment;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.periodicPayment = periodicPayment;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Broker getBroker() {
        return this.broker;
    }

    public List<Rate> getRates() {
        return this.rates;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public TariffSpecification addRate(Rate rate) {
        void rate2;
        Rate rate3 = rate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)rate3);
        this.rates.add((Rate)rate2);
        rate2.setTariffId(this.id);
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public List<Long> getSupersedes() {
        return this.supersedes;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public TariffSpecification addSupersedes(long l) {
        void specId;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        if (this.supersedes == null) {
            this.supersedes = new ArrayList<Long>();
        }
        this.supersedes.add((long)specId);
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public String toString() {
        return "TariffSpecification " + this.getId() + " " + this.getBroker().getUsername() + "." + this.getPowerType();
    }
}

