/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.powertac.common.RandomSeed;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Repository;

@Repository
public class RandomSeedRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)RandomSeedRepo.class.getName());
    private HashMap<String, RandomSeed> seedMap = new HashMap();

    public RandomSeed getRandomSeed(String classname, long id, String purpose) {
        log.info((Object)("Seed requested: " + classname + ";" + id + ";" + purpose));
        String name = this.composeName(classname, id, purpose);
        RandomSeed result = this.seedMap.get(name);
        if (result == null) {
            log.debug((Object)("New seed created: " + classname + ";" + id + ";" + purpose));
            result = new RandomSeed(classname, id, purpose);
            this.seedMap.put(this.composeName(classname, id, purpose), result);
        }
        return result;
    }

    public void loadSeeds(File inputFile) throws FileNotFoundException {
        log.info((Object)("Loading seeds from " + inputFile.getPath()));
        BufferedReader input = new BufferedReader(new FileReader(inputFile));
        String seedClass = RandomSeed.class.getName();
        try {
            String line;
            while ((line = input.readLine()) != null) {
                log.debug((Object)("line: " + line));
                String[] fields = line.split("::");
                if (!seedClass.equals(fields[1])) continue;
                if (fields.length != 8) {
                    log.error((Object)("Bad seed spec: " + line));
                    continue;
                }
                RandomSeed seed = new RandomSeed(fields[4], Long.parseLong(fields[5]), fields[6], Long.parseLong(fields[7]));
                this.seedMap.put(this.composeName(fields[4], Long.parseLong(fields[5]), fields[6]), seed);
            }
        }
        catch (IOException ioe) {
            log.error((Object)("IOException reading seedfile:" + ioe.toString()));
        }
    }

    private String composeName(String classname, long id, String purpose) {
        StringBuffer buf = new StringBuffer();
        buf.append(classname).append(";").append(id).append(";").append(purpose);
        return buf.toString();
    }

    @Override
    public void recycle() {
        this.seedMap.clear();
    }

    int size() {
        return this.seedMap.size();
    }
}

