/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Rate;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSpecification;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Repository;

@Repository
public class TariffRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)TariffRepo.class.getName());
    private HashMap<Long, TariffSpecification> specs = new HashMap();
    private HashSet<Long> deletedTariffs = new HashSet();
    private HashMap<Long, Tariff> tariffs = new HashMap();
    private HashMap<Long, Rate> rates = new HashMap();
    private HashMap<Long, BalancingOrder> balancingOrders = new HashMap();

    public synchronized void addSpecification(TariffSpecification spec) {
        if (this.isRemoved(spec.getId()) || this.specs.get(spec.getId()) != null) {
            log.error((Object)("Attempt to insert tariff spec with duplicate ID " + spec.getId()));
            return;
        }
        this.specs.put(spec.getId(), spec);
        for (Rate r : spec.getRates()) {
            this.rates.put(r.getId(), r);
        }
    }

    public synchronized TariffSpecification findSpecificationById(long id) {
        return this.specs.get(id);
    }

    public synchronized List<TariffSpecification> findAllTariffSpecifications() {
        return new ArrayList<TariffSpecification>(this.specs.values());
    }

    public synchronized void addTariff(Tariff tariff) {
        if (this.isRemoved(tariff.getId()) || this.tariffs.get(tariff.getId()) != null) {
            log.error((Object)("Attempt to insert tariff with duplicate ID " + tariff.getId()));
            return;
        }
        this.tariffs.put(tariff.getId(), tariff);
    }

    public synchronized Tariff findTariffById(long id) {
        return this.tariffs.get(id);
    }

    public synchronized List<Tariff> findAllTariffs() {
        return new ArrayList<Tariff>(this.tariffs.values());
    }

    public synchronized List<Tariff> findTariffsByState(Tariff.State state) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (state != tariff.getState()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized List<Tariff> findActiveTariffs(PowerType type) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (tariff.getPowerType() != type || !tariff.isActive() || tariff.isExpired() || tariff.isRevoked()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized List<Tariff> findAllActiveTariffs(PowerType type) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (!type.canUse(tariff.getPowerType()) || !tariff.isActive() || tariff.isExpired() || tariff.isRevoked()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized void removeTariff(Tariff tariff) {
        this.tariffs.remove(tariff.getId());
        this.deletedTariffs.add(tariff.getId());
        this.specs.remove(tariff.getId());
    }

    public synchronized boolean isRemoved(long tariffId) {
        return this.deletedTariffs.contains(tariffId);
    }

    public synchronized Rate findRateById(long id) {
        return this.rates.get(id);
    }

    public synchronized void addBalancingOrder(BalancingOrder order) {
        if (this.specs.get(order.getTariffId()) != null) {
            this.balancingOrders.put(order.getTariffId(), order);
        }
    }

    public synchronized Collection<BalancingOrder> getBalancingOrders() {
        return this.balancingOrders.values();
    }

    @Override
    public synchronized void recycle() {
        this.specs.clear();
        this.tariffs.clear();
        this.deletedTariffs.clear();
        this.rates.clear();
        this.balancingOrders.clear();
    }
}

