/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.powertac.common.Competition;

@XStreamAlias(value="slot")
public class Timeslot {
    @XStreamAsAttribute
    private int serialNumber;
    @XStreamOmitField
    private Instant startInstant;
    @XStreamOmitField
    private DateTime startTime = null;

    public Timeslot(int serial, Instant start) {
        this.serialNumber = serial;
        this.startInstant = start;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public long getId() {
        return this.serialNumber;
    }

    public Instant getStartInstant() {
        return this.startInstant;
    }

    public Instant getEndInstant() {
        return this.startInstant.plus(Competition.currentCompetition().getTimeslotDuration());
    }

    public DateTime getStartTime() {
        if (this.startTime == null) {
            this.startTime = new DateTime((Object)this.startInstant, DateTimeZone.UTC);
        }
        return this.startTime;
    }

    public int slotInDay() {
        long millis = this.getStartTime().getMillisOfDay();
        return (int)(millis / Competition.currentCompetition().getTimeslotDuration());
    }

    public int dayOfWeek() {
        return this.getStartTime().getDayOfWeek();
    }

    public String toString() {
        return "timeslot " + this.serialNumber + ":" + this.startInstant.toString();
    }
}

