/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Repository;

@Repository
public class BrokerRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)BrokerRepo.class.getName());
    private HashMap<String, Broker> nameTable = new HashMap();
    private HashMap<Long, Broker> idTable = new HashMap();
    private static BrokerRepo instance;

    public BrokerRepo() {
        instance = this;
    }

    public void add(Broker broker) {
        log.debug((Object)("add " + broker.getUsername()));
        this.nameTable.put(broker.getUsername(), broker);
        this.idTable.put(broker.getId(), broker);
    }

    public Collection<Broker> list() {
        return this.nameTable.values();
    }

    public Broker findByUsername(String username) {
        log.debug((Object)("find " + username));
        return this.nameTable.get(username);
    }

    public Broker findOrCreateByUsername(String username) {
        Broker broker = this.findByUsername(username);
        if (broker == null) {
            broker = new Broker(username);
            this.add(broker);
        }
        return broker;
    }

    public Broker findById(long id) {
        log.debug((Object)("find " + id));
        return this.idTable.get(id);
    }

    public List<String> findRetailBrokerNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Broker broker : this.nameTable.values()) {
            if (broker.isWholesale()) continue;
            result.add(broker.getUsername());
        }
        return result;
    }

    public List<Broker> findRetailBrokers() {
        ArrayList<Broker> result = new ArrayList<Broker>();
        for (Broker broker : this.nameTable.values()) {
            if (broker.isWholesale()) continue;
            result.add(broker);
        }
        return result;
    }

    public List<Broker> findWholesaleBrokers() {
        ArrayList<Broker> result = new ArrayList<Broker>();
        for (Broker broker : this.nameTable.values()) {
            if (!broker.isWholesale()) continue;
            result.add(broker);
        }
        return result;
    }

    public List<Broker> findDisabledBrokers() {
        ArrayList<Broker> result = new ArrayList<Broker>();
        for (Broker broker : this.nameTable.values()) {
            if (broker.isEnabled()) continue;
            result.add(broker);
        }
        return result;
    }

    @Override
    public void recycle() {
        log.debug((Object)"recycle");
        this.nameTable.clear();
        this.idTable.clear();
    }

    public static BrokerRepo getInstance() {
        return instance;
    }
}

