/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.powertac.common.RandomSeed;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Repository;

@Repository
public class RandomSeedRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)RandomSeedRepo.class.getName());
    private HashMap<String, RandomSeed> seedMap = new HashMap();
    private HashMap<String, Long> pendingSeedMap = new HashMap();

    public RandomSeed getRandomSeed(String classname, long id, String purpose) {
        log.info((Object)("Seed requested: " + classname + ";" + id + ";" + purpose));
        String name = this.composeName(classname, id, purpose);
        RandomSeed result = this.seedMap.get(name);
        if (result == null) {
            Long seedValue = this.pendingSeedMap.get(name);
            if (seedValue == null) {
                log.debug((Object)("New seed created: " + classname + ";" + id + ";" + purpose));
                result = new RandomSeed(classname, id, purpose);
            } else {
                log.info((Object)("Stored seed " + seedValue + " retrieved for " + name));
                result = new RandomSeed(classname, id, purpose, seedValue);
            }
            this.seedMap.put(name, result);
        } else {
            log.info((Object)("Seed from map for " + name));
        }
        return result;
    }

    public void loadSeeds(File inputFile) throws FileNotFoundException {
        log.info((Object)("Loading seeds from file" + inputFile.getPath()));
        this.loadSeeds(new FileReader(inputFile));
    }

    public void loadSeeds(InputStreamReader reader) {
        BufferedReader input = new BufferedReader(reader);
        String seedClass = RandomSeed.class.getName();
        try {
            String line;
            while ((line = input.readLine()) != null) {
                log.debug((Object)("original line: " + line));
                int colon = line.indexOf(58);
                if (colon <= 0 || line.length() <= colon + 2) {
                    log.warn((Object)("Malformed line " + line));
                    break;
                }
                String[] fields = (line = line.substring(colon + 1)).split("::");
                if (!seedClass.equals(fields[0])) continue;
                if (fields.length != 7) {
                    log.error((Object)("Bad seed spec: " + line));
                    continue;
                }
                System.out.println("fields[3, 4, 5, 6]: " + fields[3] + "," + fields[4] + "," + fields[5] + "," + fields[6]);
                this.pendingSeedMap.put(this.composeName(fields[3], Long.parseLong(fields[4]), fields[5]), Long.parseLong(fields[6]));
            }
        }
        catch (IOException ioe) {
            log.error((Object)("IOException reading seedfile:" + ioe.toString()));
        }
    }

    private String composeName(String classname, long id, String purpose) {
        StringBuffer buf = new StringBuffer();
        buf.append(classname).append(";").append(id).append(";").append(purpose);
        return buf.toString();
    }

    @Override
    public void recycle() {
        this.seedMap.clear();
        this.pendingSeedMap.clear();
    }

    int size() {
        return this.seedMap.size();
    }
}

