/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
public class RegulationCapacity {
    protected static Logger log;
    long id;
    private static double epsilon;
    private double upRegulationCapacity;
    private double downRegulationCapacity;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        Factory factory = new Factory("RegulationCapacity.java", Class.forName("org.powertac.common.RegulationCapacity"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.RegulationCapacity", "double:double:", "upRegulationCapacity:downRegulationCapacity:", ""), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUpRegulationCapacity", "org.powertac.common.RegulationCapacity", "double:", "value:", "", "void"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDownRegulationCapacity", "org.powertac.common.RegulationCapacity", "double:", "value:", "", "void"), 112);
        log = Logger.getLogger((String)RegulationCapacity.class.getName());
        epsilon = 1.0E-4;
    }

    public RegulationCapacity(double upRegulationCapacity, double downRegulationCapacity) {
        double d = upRegulationCapacity;
        double d2 = downRegulationCapacity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d), (Object)Conversions.doubleObject((double)d2));
        this.id = IdGenerator.createId();
        this.upRegulationCapacity = 0.0;
        this.downRegulationCapacity = 0.0;
        if (upRegulationCapacity < 0.0) {
            log.warn((Object)("upRegulationCapacity " + upRegulationCapacity + " < 0.0"));
            upRegulationCapacity = 0.0;
        }
        if (downRegulationCapacity > 0.0) {
            log.warn((Object)("downRegulationCapacity " + downRegulationCapacity + " > 0.0"));
            downRegulationCapacity = 0.0;
        }
        this.upRegulationCapacity = upRegulationCapacity;
        this.downRegulationCapacity = downRegulationCapacity;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public double getUpRegulationCapacity() {
        return this.upRegulationCapacity;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setUpRegulationCapacity(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        double filteredValue = this.filterValue((double)value);
        if (filteredValue < 0.0) {
            log.warn((Object)("Attempt to set negative up-regulation capacity " + filteredValue));
        } else {
            this.upRegulationCapacity = filteredValue;
        }
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getDownRegulationCapacity() {
        return this.downRegulationCapacity;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public void setDownRegulationCapacity(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        double filteredValue = this.filterValue((double)value);
        if (filteredValue > 0.0) {
            log.warn((Object)("Attempt to set positive down-regulation capacity " + filteredValue));
        } else {
            this.downRegulationCapacity = filteredValue;
        }
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public void add(RegulationCapacity rc) {
        this.setUpRegulationCapacity(this.upRegulationCapacity + rc.upRegulationCapacity);
        this.setDownRegulationCapacity(this.downRegulationCapacity + rc.downRegulationCapacity);
    }

    public void addUpRegulation(double amount) {
        if (amount < 0.0) {
            log.warn((Object)("Attempt to add negative up-regulation capacity " + amount));
            return;
        }
        this.setUpRegulationCapacity(this.upRegulationCapacity + amount);
    }

    public void addDownRegulation(double amount) {
        if (amount > 0.0) {
            log.warn((Object)("Attempt to add positive down-regulation capacity " + amount));
            return;
        }
        this.setDownRegulationCapacity(this.downRegulationCapacity + amount);
    }

    private double filterValue(double original) {
        if (Math.abs(original) < epsilon) {
            return 0.0;
        }
        return original;
    }
}

