/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffSubscription;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.spring.SpringApplicationContext;

public class TariffEvaluator {
    private static Logger log = Logger.getLogger((String)TariffEvaluator.class.getName());
    TariffRepo tariffRepo;
    TariffMarket tariffMarket;
    TariffSubscriptionRepo tariffSubscriptionRepo;
    private CustomerModelAccessor accessor;
    private CustomerInfo customerInfo;
    private double touFactor = 0.2;
    private double tieredRateFactor = 0.1;
    private double variablePricingFactor = 0.5;
    private double interruptibilityFactor = 0.2;
    private int signupFeePeriod = 6;
    private TariffEvaluationHelper helper;
    private int chunkSize = 1;
    private int maxChunkCount = 200;
    private int tariffEvalDepth = 5;
    private double inertia = 0.8;
    private double rationality = 0.9;
    private double inconvenienceWeight = 0.2;
    private double tariffSwitchFactor = 0.04;
    private double preferredDuration = 6.0;
    private int evaluationCounter = 0;
    private HashMap<Tariff, EvalData> evaluatedTariffs;
    private HashMap<Tariff, Integer> allocations;
    private double lambdaMax = 50.0;
    private double maxLinearUtility = 7.0;

    public TariffEvaluator(CustomerModelAccessor cma) {
        this.accessor = cma;
        this.customerInfo = cma.getCustomerInfo();
        this.helper = new TariffEvaluationHelper();
        this.evaluatedTariffs = new HashMap();
        this.allocations = new HashMap();
    }

    private String getName() {
        return this.customerInfo.getName();
    }

    public void initializeCostFactors(double wtExpected, double wtMax, double wtRealized, double soldThreshold) {
        this.helper.initializeCostFactors(wtExpected, wtMax, wtRealized, soldThreshold);
    }

    public void initializeInconvenienceFactors(double touFactor, double tieredRateFactor, double variablePricingFactor, double interruptibilityFactor) {
        this.touFactor = touFactor;
        this.tieredRateFactor = tieredRateFactor;
        this.variablePricingFactor = variablePricingFactor;
        this.interruptibilityFactor = interruptibilityFactor;
    }

    public void initializeRegulationFactors(double expectedCurtailment, double expectedDischarge, double expectedDownRegulation) {
        double expDown;
        double expDis;
        double expCurtail = expectedCurtailment;
        if (expCurtail > 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": expectedCurtailment " + expCurtail + " must be non-positive"));
            expCurtail = 0.0;
        }
        if ((expDis = expectedDischarge) > 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": expectedDischarge " + expDis + " must be non-positive"));
            expDis = 0.0;
        }
        if ((expDown = expectedDownRegulation) < 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": expectedDownRegulation " + expDown + " must be non-negative"));
            expDown = 0.0;
        }
        this.helper.initializeRegulationFactors(expCurtail, expDis, expDown);
    }

    public TariffEvaluator withChunkSize(int size) {
        if (size > 0) {
            this.chunkSize = size;
        } else {
            log.error((Object)("chunk size " + size + " < 0"));
        }
        return this;
    }

    public TariffEvaluator withTariffEvalDepth(int depth) {
        this.tariffEvalDepth = depth;
        return this;
    }

    public TariffEvaluator withInertia(double inertia) {
        this.inertia = inertia;
        return this;
    }

    public TariffEvaluator withRationality(double rationality) {
        this.rationality = rationality;
        if (rationality < 0.0) {
            log.error((Object)("Rationality " + rationality + "< 0.0"));
            this.rationality = 0.01;
        } else if (rationality > 1.0) {
            log.error((Object)("Rationality " + rationality + "> 1.0"));
            this.rationality = 1.0;
        }
        return this;
    }

    public TariffEvaluator withInconvenienceWeight(double weight) {
        this.inconvenienceWeight = weight;
        return this;
    }

    public TariffEvaluator withTariffSwitchFactor(double factor) {
        this.tariffSwitchFactor = factor;
        return this;
    }

    public TariffEvaluator withPreferredContractDuration(double days) {
        this.preferredDuration = days;
        return this;
    }

    public void evaluateTariffs() {
        this.allocations.clear();
        HashSet<Tariff> newTariffs = new HashSet<Tariff>(this.getTariffRepo().findRecentActiveTariffs(this.tariffEvalDepth, this.customerInfo.getPowerType()));
        this.addSupersedingTariffs(newTariffs);
        double actualInertia = Math.max(0.0, (1.0 - Math.pow(2.0, 1 - this.evaluationCounter)) * this.inertia);
        ++this.evaluationCounter;
        EvalData defaultEval = this.getDefaultTariffEval();
        for (Tariff tariff : newTariffs) {
            EvalData eval = this.evaluatedTariffs.get(tariff);
            if (eval != null) continue;
            double cost = this.forecastCost(tariff);
            double hassle = this.computeInconvenience(tariff);
            log.info((Object)("Evaluated tariff " + tariff.getId() + ": cost=" + cost + ", inconvenience=" + hassle));
            eval = new EvalData(cost, hassle);
            this.evaluatedTariffs.put(tariff, eval);
        }
        for (TariffSubscription subscription : this.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(this.customerInfo)) {
            Tariff subTariff = subscription.getTariff();
            double withdrawCost = subTariff.getEarlyWithdrawPayment();
            int committedCount = subscription.getCustomersCommitted();
            int expiredCount = subscription.getExpiredCustomerCount();
            if (withdrawCost == 0.0 || expiredCount == committedCount) {
                this.evaluateAlternativeTariffs(subscription, actualInertia, 0.0, committedCount, this.getDefaultTariff(), defaultEval, newTariffs);
                continue;
            }
            this.evaluateAlternativeTariffs(subscription, actualInertia, 0.0, expiredCount, this.getDefaultTariff(), defaultEval, newTariffs);
            this.evaluateAlternativeTariffs(subscription, actualInertia, withdrawCost, committedCount - expiredCount, this.getDefaultTariff(), defaultEval, newTariffs);
        }
        this.updateSubscriptions();
    }

    private void addSupersedingTariffs(HashSet<Tariff> newTariffs) {
        List<TariffSubscription> revokedSubscriptions = this.getTariffSubscriptionRepo().getRevokedSubscriptionList(this.customerInfo);
        for (TariffSubscription sub : revokedSubscriptions) {
            Tariff supTariff = sub.getTariff().getIsSupersededBy();
            if (supTariff == null || !supTariff.isSubscribable()) continue;
            newTariffs.add(supTariff);
        }
    }

    private void evaluateAlternativeTariffs(TariffSubscription current, double inertia, double withdraw0, int population, Tariff defaultTariff, EvalData defaultEval, Set<Tariff> initialTariffs) {
        int remainingPopulation;
        PriorityQueue<TariffUtility> evals = new PriorityQueue<TariffUtility>();
        HashSet<Tariff> tariffs = new HashSet<Tariff>(initialTariffs);
        tariffs.add(defaultTariff);
        Tariff currentTariff = current.getTariff();
        boolean revoked = false;
        Tariff replacementTariff = null;
        if (currentTariff.getState() == Tariff.State.KILLED) {
            revoked = true;
            replacementTariff = currentTariff.getIsSupersededBy();
            log.info((Object)("Customer " + this.customerInfo.getName() + ": tariff " + currentTariff.getId() + " revoked, superseded by " + (replacementTariff == null ? "default" : Long.valueOf(replacementTariff.getId()))));
            if (replacementTariff == null) {
                replacementTariff = defaultTariff;
            }
            withdraw0 = 0.0;
        } else {
            tariffs.add(currentTariff);
        }
        for (Tariff tariff : tariffs) {
            EvalData eval = this.evaluatedTariffs.get(tariff);
            double inconvenience = eval.inconvenience;
            double cost = eval.costEstimate;
            if (tariff != currentTariff && tariff != replacementTariff) {
                inconvenience += this.tariffSwitchFactor;
                if (tariff.getBroker() != currentTariff.getBroker()) {
                    inconvenience += this.accessor.getBrokerSwitchFactor(revoked);
                }
                cost = tariff.getSignupPayment() < 0.0 ? (cost += tariff.getSignupPayment() * this.preferredDuration * 24.0 / (double)this.signupFeePeriod) : (cost += tariff.getSignupPayment());
                cost += withdraw0;
                double withdrawFactor = Math.min(1.0, (double)tariff.getMinDuration() / (this.preferredDuration * 8.64E7));
                cost += withdrawFactor * tariff.getEarlyWithdrawPayment();
            }
            if (revoked && tariff == currentTariff) continue;
            double utility = this.computeNormalizedDifference(cost, defaultEval.costEstimate);
            evals.add(new TariffUtility(tariff, this.constrainUtility(utility -= this.inconvenienceWeight * inconvenience)));
        }
        double logitDenominator = 0.0;
        double lambda = Math.pow(this.lambdaMax, this.rationality) - 1.0;
        for (TariffUtility util : evals) {
            logitDenominator += Math.exp(lambda * util.utility);
        }
        for (TariffUtility util : evals) {
            util.probability = Math.exp(lambda * util.utility) / logitDenominator;
            if (!Double.isNaN(util.probability)) continue;
            log.error((Object)("Probability NAN, util=" + util.utility + ", denom=" + logitDenominator + ", tariff " + util.tariff));
            util.probability = 0.0;
        }
        int chunk = remainingPopulation = population;
        if (this.customerInfo.isMultiContracting()) {
            chunk = this.getChunkSize(population);
        }
        while (remainingPopulation > 0) {
            int count = Math.min(remainingPopulation, chunk);
            remainingPopulation -= count;
            double inertiaSample = this.accessor.getInertiaSample();
            if (!revoked && inertiaSample < inertia) continue;
            double tariffSample = this.accessor.getTariffChoiceSample();
            boolean allocated = false;
            for (TariffUtility tu : evals) {
                if (tariffSample <= tu.probability) {
                    this.addAllocation(currentTariff, tu.tariff, count);
                    allocated = true;
                    break;
                }
                tariffSample -= tu.probability;
            }
            if (allocated) continue;
            log.error((Object)("Failed to allocate: P=" + tariffSample));
        }
    }

    private double constrainUtility(double utility) {
        if (utility > this.maxLinearUtility) {
            double compressed = Math.log10(utility - this.maxLinearUtility);
            return Math.min(this.maxLinearUtility + compressed, this.maxLinearUtility * 2.0);
        }
        if (utility < -this.maxLinearUtility) {
            return -this.maxLinearUtility;
        }
        return utility;
    }

    private double computeNormalizedDifference(double cost, double defaultCost) {
        double ndiff = (defaultCost - cost) / defaultCost;
        if (this.customerInfo.getPowerType().isProduction()) {
            ndiff = -ndiff;
        }
        return ndiff;
    }

    private Tariff getDefaultTariff() {
        return this.getTariffMarket().getDefaultTariff(this.customerInfo.getPowerType());
    }

    private EvalData getDefaultTariffEval() {
        Tariff defaultTariff = this.getDefaultTariff();
        EvalData defaultEval = this.evaluatedTariffs.get(defaultTariff);
        if (defaultEval == null) {
            defaultEval = new EvalData(this.forecastCost(defaultTariff), 0.0);
            this.evaluatedTariffs.put(defaultTariff, defaultEval);
        }
        return defaultEval;
    }

    private double forecastCost(Tariff tariff) {
        double[] profile = this.accessor.getCapacityProfile(tariff);
        double profileCost = this.helper.estimateCost(tariff, profile);
        double scale = this.preferredDuration * 24.0 / (double)profile.length;
        return profileCost * scale;
    }

    private void addAllocation(Tariff current, Tariff newTariff, int count) {
        if (current == newTariff) {
            return;
        }
        Integer ac = this.allocations.get(current);
        ac = ac == null ? Integer.valueOf(-count) : Integer.valueOf(ac - count);
        this.allocations.put(current, ac);
        ac = this.allocations.get(newTariff);
        ac = ac == null ? Integer.valueOf(count) : Integer.valueOf(ac + count);
        this.allocations.put(newTariff, ac);
    }

    private void updateSubscriptions() {
        int check = 0;
        for (Tariff tariff : this.allocations.keySet()) {
            int count = this.allocations.get(tariff);
            check += count;
            if (count < 0) {
                TariffSubscription sub = this.getTariffSubscriptionRepo().findSubscriptionForTariffAndCustomer(tariff, this.customerInfo);
                sub.unsubscribe(-count);
                log.info((Object)("customer " + this.customerInfo.getName() + " unsubscribes " + -count + " from tariff " + tariff.getId()));
                continue;
            }
            if (count <= 0) continue;
            this.getTariffMarket().subscribeToTariff(tariff, this.customerInfo, count);
            log.info((Object)("customer " + this.customerInfo.getName() + " subscribes " + count + " to tariff " + tariff.getId()));
        }
        if (check != 0) {
            log.error((Object)("Subscription updates do not add up for " + this.customerInfo.getName() + ": " + check));
        }
    }

    public double getTouFactor() {
        return this.touFactor;
    }

    public double getTieredRateFactor() {
        return this.tieredRateFactor;
    }

    public double getVariablePricingFactor() {
        return this.variablePricingFactor;
    }

    public double getInterruptibilityFactor() {
        return this.interruptibilityFactor;
    }

    public double computeInconvenience(Tariff tariff) {
        double result = 0.0;
        if (tariff.isTimeOfUse()) {
            result += this.touFactor;
        }
        if (tariff.isTiered()) {
            result += this.tieredRateFactor;
        }
        if (tariff.isVariableRate()) {
            result += this.variablePricingFactor;
        }
        if (tariff.isInterruptible()) {
            result += this.interruptibilityFactor;
        }
        return result;
    }

    private int getChunkSize(int population) {
        if (population <= this.chunkSize) {
            return population;
        }
        return Math.max(population / this.maxChunkCount, this.chunkSize);
    }

    private TariffRepo getTariffRepo() {
        if (this.tariffRepo != null) {
            return this.tariffRepo;
        }
        this.tariffRepo = (TariffRepo)SpringApplicationContext.getBean("tariffRepo");
        return this.tariffRepo;
    }

    private TariffSubscriptionRepo getTariffSubscriptionRepo() {
        if (this.tariffSubscriptionRepo != null) {
            return this.tariffSubscriptionRepo;
        }
        this.tariffSubscriptionRepo = (TariffSubscriptionRepo)SpringApplicationContext.getBean("tariffSubscriptionRepo");
        return this.tariffSubscriptionRepo;
    }

    private TariffMarket getTariffMarket() {
        if (this.tariffMarket != null) {
            return this.tariffMarket;
        }
        this.tariffMarket = (TariffMarket)SpringApplicationContext.getBean("tariffMarketService");
        return this.tariffMarket;
    }

    class EvalData {
        double costEstimate;
        double inconvenience;

        EvalData(double cost, double inconvenience) {
            this.costEstimate = cost;
            this.inconvenience = inconvenience;
        }
    }

    class TariffUtility
    implements Comparable<TariffUtility> {
        Tariff tariff;
        double utility;
        double probability = 0.0;

        TariffUtility(Tariff tariff, double utility) {
            this.tariff = tariff;
            this.utility = utility;
        }

        @Override
        public int compareTo(TariffUtility other) {
            double result = other.utility - this.utility;
            if (result == 0.0) {
                return (int)(other.tariff.getId() - this.tariff.getId());
            }
            if (result > 0.0) {
                return 1;
            }
            return -1;
        }
    }
}

