/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.spring.SpringApplicationContext;

public class TariffSubscription {
    private static Logger log = Logger.getLogger((String)TariffSubscription.class.getName());
    long id = IdGenerator.createId();
    private TimeService timeService;
    private Accounting accountingService;
    private TariffMarket tariffMarketService;
    private CustomerInfo customer;
    private Tariff tariff;
    private int customersCommitted = 0;
    private List<ExpirationRecord> expirations;
    private double totalUsage = 0.0;
    private int pendingUnsubscribeCount = 0;
    private double pendingRegulationRatio = 0.0;
    RegulationCapacity regulationCapacity = new RegulationCapacity(0.0, 0.0);
    private double regulation = 0.0;

    public TariffSubscription(CustomerInfo customer, Tariff tariff) {
        this.customer = customer;
        this.tariff = tariff;
        this.expirations = new ArrayList<ExpirationRecord>();
    }

    public long getId() {
        return this.id;
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public Tariff getTariff() {
        return this.tariff;
    }

    public int getCustomersCommitted() {
        return this.customersCommitted;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    public void subscribe(int customerCount) {
        this.customersCommitted += customerCount;
        long minDuration = this.tariff.getMinDuration();
        Instant start = this.getTimeService().truncateInstant(this.getTimeService().getCurrentTime(), 86400000L);
        if (this.expirations.size() > 0 && this.expirations.get(this.expirations.size() - 1).getHorizon() == start.getMillis() + minDuration) {
            this.expirations.get(this.expirations.size() - 1).updateCount(customerCount);
        } else {
            this.expirations.add(new ExpirationRecord(start.getMillis() + minDuration, customerCount));
        }
        if (this.tariff.getSignupPayment() != 0.0) {
            log.debug((Object)("signup bonus: " + customerCount + " customers, total = " + (double)customerCount * this.tariff.getSignupPayment()));
        }
        this.getAccounting().addTariffTransaction(TariffTransaction.Type.SIGNUP, this.tariff, this.customer, customerCount, 0.0, (double)customerCount * -this.tariff.getSignupPayment());
    }

    public void unsubscribe(int customerCount) {
        this.getTariffMarket().subscribeToTariff(this.getTariff(), this.getCustomer(), -customerCount);
        this.pendingUnsubscribeCount += customerCount;
    }

    public void deferredUnsubscribe(int customerCount) {
        this.pendingUnsubscribeCount = 0;
        customerCount = Math.min(customerCount, this.customersCommitted);
        int freeAgentCount = this.getExpiredCustomerCount();
        int penaltyCount = Math.max(customerCount - freeAgentCount, 0);
        int expCount = customerCount;
        while (expCount > 0 && this.expirations.get(0) != null) {
            int cec = this.expirations.get(0).getCount();
            if (cec <= expCount) {
                expCount -= cec;
                this.expirations.remove(0);
                continue;
            }
            this.expirations.get(0).updateCount(-expCount);
            expCount = 0;
        }
        this.customersCommitted -= customerCount;
        if (!this.tariff.isRevoked()) {
            this.getAccounting().addTariffTransaction(TariffTransaction.Type.WITHDRAW, this.tariff, this.customer, customerCount, 0.0, (double)penaltyCount * -this.tariff.getEarlyWithdrawPayment());
        }
    }

    public Tariff handleRevokedTariff() {
        if (!this.tariff.isRevoked()) {
            log.warn((Object)("Tariff " + this.tariff.getId() + " is not revoked."));
            return this.tariff;
        }
        if (this.customersCommitted == 0) {
            return null;
        }
        Tariff newTariff = null;
        if (newTariff == null) {
            newTariff = this.getTariffMarket().getDefaultTariff(this.tariff.getTariffSpec().getPowerType());
        }
        if (newTariff == null) {
            newTariff = this.getTariffMarket().getDefaultTariff(this.tariff.getTariffSpec().getPowerType().getGenericType());
        }
        this.getTariffMarket().subscribeToTariff(this.tariff, this.customer, -this.customersCommitted);
        this.getTariffMarket().subscribeToTariff(newTariff, this.customer, this.customersCommitted);
        log.info((Object)("Tariff " + this.tariff.getId() + " superseded by " + newTariff.getId() + " for " + this.customersCommitted + " customers"));
        return newTariff;
    }

    public void usePower(double kwh) {
        this.ensureRegulationCapacity();
        double kWhPerMember = kwh / (double)this.customersCommitted;
        double actualKwh = (kWhPerMember - this.getEconomicRegulation(kWhPerMember, this.totalUsage)) * (double)this.customersCommitted;
        log.info((Object)("usePower " + kwh + ", actual " + actualKwh + ", customer=" + this.customer.getName()));
        TariffTransaction.Type txType = actualKwh < 0.0 ? TariffTransaction.Type.PRODUCE : TariffTransaction.Type.CONSUME;
        this.getAccounting().addTariffTransaction(txType, this.tariff, this.customer, this.customersCommitted, -actualKwh, (double)this.customersCommitted * -this.tariff.getUsageCharge(actualKwh / (double)this.customersCommitted, this.totalUsage, true));
        if (this.getTimeService().getHourOfDay() == 0) {
            this.totalUsage = 0.0;
        }
        this.totalUsage += actualKwh / (double)this.customersCommitted;
        if (this.tariff.getPeriodicPayment() != 0.0) {
            this.getAccounting().addTariffTransaction(TariffTransaction.Type.PERIODIC, this.tariff, this.customer, this.customersCommitted, 0.0, (double)this.customersCommitted * -this.tariff.getPeriodicPayment() / 24.0);
        }
    }

    @Deprecated
    public synchronized double getCurtailment() {
        double sgn = 1.0;
        if (this.tariff.getPowerType().isProduction()) {
            sgn = -1.0;
        }
        double result = sgn * Math.max(sgn * this.regulation, 0.0) * (double)this.customersCommitted;
        this.regulation = 0.0;
        return result;
    }

    public synchronized double getRegulation() {
        double result = this.regulation;
        this.regulation = 0.0;
        return result;
    }

    public void setRegulationCapacity(RegulationCapacity capacity) {
        this.regulationCapacity = capacity;
    }

    public void ensureRegulationCapacity() {
        if (this.regulationCapacity == null) {
            this.regulationCapacity = new RegulationCapacity(0.0, 0.0);
        }
    }

    public boolean hasRegulationRate() {
        return this.tariff.hasRegulationRate();
    }

    double getEconomicRegulation(double proposedUsage, double cumulativeUsage) {
        this.regulation = 0.0;
        double result = 0.0;
        if (this.getTariff().hasRegulationRate()) {
            if (this.pendingRegulationRatio < 0.0) {
                result = -this.pendingRegulationRatio * this.regulationCapacity.getDownRegulationCapacity();
                this.regulationCapacity.setDownRegulationCapacity(this.regulationCapacity.getDownRegulationCapacity() - result);
            } else if (this.pendingRegulationRatio > 1.0) {
                if (this.regulationCapacity.getUpRegulationCapacity() > proposedUsage) {
                    double excess = this.regulationCapacity.getUpRegulationCapacity() - proposedUsage;
                    result = proposedUsage + (this.pendingRegulationRatio - 1.0) * excess;
                    this.regulationCapacity.setUpRegulationCapacity(this.regulationCapacity.getUpRegulationCapacity() - result);
                }
            } else {
                result = this.pendingRegulationRatio * this.regulationCapacity.getUpRegulationCapacity();
                this.regulationCapacity.setUpRegulationCapacity(this.regulationCapacity.getUpRegulationCapacity() - result);
            }
        } else {
            double proposedUpRegulation = proposedUsage * this.pendingRegulationRatio;
            double mur = this.tariff.getMaxUpRegulation(proposedUsage, cumulativeUsage);
            result = Math.min(proposedUpRegulation, mur);
            log.debug((Object)("proposedUpRegulation=" + proposedUpRegulation + ", maxUpRegulation=" + mur));
            this.regulationCapacity.setUpRegulationCapacity(mur - result);
        }
        this.addRegulation(result);
        this.pendingRegulationRatio = 0.0;
        return result;
    }

    public synchronized void postRatioControl(double ratio) {
        this.pendingRegulationRatio = ratio;
    }

    public synchronized void postBalancingControl(double kwh) {
        TariffTransaction.Type txType = kwh > 0.0 ? TariffTransaction.Type.PRODUCE : TariffTransaction.Type.CONSUME;
        this.getAccounting().addTariffTransaction(txType, this.tariff, this.customer, this.customersCommitted, kwh, (double)this.customersCommitted * this.tariff.getRegulationCharge(-kwh / (double)this.customersCommitted, this.totalUsage, true));
        double kWhPerMember = kwh / (double)this.customersCommitted;
        this.addRegulation(kWhPerMember);
        if (kWhPerMember >= 0.0) {
            this.regulationCapacity.setUpRegulationCapacity(this.regulationCapacity.getUpRegulationCapacity() - kWhPerMember);
        } else {
            this.regulationCapacity.setDownRegulationCapacity(this.regulationCapacity.getDownRegulationCapacity() - kWhPerMember);
        }
        this.totalUsage -= kWhPerMember;
    }

    public RegulationCapacity getRemainingRegulationCapacity() {
        double up = this.regulationCapacity.getUpRegulationCapacity() * (double)this.customersCommitted;
        double down = this.regulationCapacity.getDownRegulationCapacity() * (double)this.customersCommitted;
        if (this.pendingUnsubscribeCount == 0) {
            log.info((Object)("regulation capacity for " + this.getCustomer().getName() + " (" + up + ", " + down + ")"));
            return new RegulationCapacity(up, down);
        }
        double ratio = (double)(this.customersCommitted - this.pendingUnsubscribeCount) / (double)this.customersCommitted;
        log.info((Object)("remaining regulation capacity for " + this.getCustomer().getName() + " reduced by " + ratio + " to (" + up * ratio + ", " + down * ratio + ")"));
        return new RegulationCapacity(up * ratio, down * ratio);
    }

    void addRegulation(double kwh) {
        this.regulation += kwh;
    }

    private TimeService getTimeService() {
        if (this.timeService == null) {
            this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        }
        return this.timeService;
    }

    private Accounting getAccounting() {
        if (this.accountingService == null) {
            this.accountingService = (Accounting)SpringApplicationContext.getBean("accountingService");
        }
        return this.accountingService;
    }

    private TariffMarket getTariffMarket() {
        if (this.tariffMarketService == null) {
            this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean("tariffMarketService");
        }
        return this.tariffMarketService;
    }

    public int getExpiredCustomerCount() {
        int cc = 0;
        Instant today = this.getTimeService().truncateInstant(this.getTimeService().getCurrentTime(), 86400000L);
        for (ExpirationRecord exp : this.expirations) {
            if (exp.getHorizon() > today.getMillis()) continue;
            cc += exp.getCount();
        }
        return cc;
    }

    private class ExpirationRecord {
        private long horizon;
        private int count;

        ExpirationRecord(long horizon, int count) {
            this.horizon = horizon;
            this.count = count;
        }

        long getHorizon() {
            return this.horizon;
        }

        int getCount() {
            return this.count;
        }

        int updateCount(int increment) {
            this.count += increment;
            return this.count;
        }
    }
}

