/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SpringApplicationContext
implements ApplicationContextAware {
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        context = appContext;
    }

    public static Object getBean(String beanName) {
        if (context != null) {
            return context.getBean(beanName);
        }
        return null;
    }

    public static <T> T getBeanByType(Class<T> type) {
        T bean = null;
        Collection beans = context.getBeansOfType(type).values();
        if (beans.size() > 0) {
            bean = (T)new ArrayList(beans).get(0);
        }
        return bean;
    }

    public static <T> List<T> listBeansOfType(Class<T> type) {
        return new ArrayList(context.getBeansOfType(type).values());
    }

    public static <T> Map<String, T> mapBeansOfType(Class<T> type) {
        return context.getBeansOfType(type);
    }

    public static ApplicationContext getContext() {
        return context;
    }
}

