/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import org.apache.log4j.Logger;
import org.powertac.common.IdGenerator;
import org.powertac.common.TariffSubscription;

public class RegulationCapacity {
    protected static Logger log = Logger.getLogger((String)RegulationCapacity.class.getName());
    long id = IdGenerator.createId();
    private static double epsilon = 1.0E-4;
    private double upRegulationCapacity = 0.0;
    private double downRegulationCapacity = 0.0;
    private TariffSubscription subscription;

    public RegulationCapacity(TariffSubscription subscription, double upRegulationCapacity, double downRegulationCapacity) {
        this.subscription = subscription;
        if (upRegulationCapacity < 0.0) {
            log.warn((Object)("upRegulationCapacity " + upRegulationCapacity + " < 0.0"));
            upRegulationCapacity = 0.0;
        }
        if (downRegulationCapacity > 0.0) {
            log.warn((Object)("downRegulationCapacity " + downRegulationCapacity + " > 0.0"));
            downRegulationCapacity = 0.0;
        }
        this.upRegulationCapacity = upRegulationCapacity;
        this.downRegulationCapacity = downRegulationCapacity;
    }

    public long getId() {
        return this.id;
    }

    public double getUpRegulationCapacity() {
        return this.upRegulationCapacity;
    }

    public void setUpRegulationCapacity(double value) {
        double filteredValue = this.filterValue(value);
        if (filteredValue < 0.0) {
            log.warn((Object)("Attempt to set negative up-regulation capacity " + filteredValue));
            return;
        }
        this.upRegulationCapacity = filteredValue;
    }

    public double getDownRegulationCapacity() {
        return this.downRegulationCapacity;
    }

    public void setDownRegulationCapacity(double value) {
        double filteredValue = this.filterValue(value);
        if (filteredValue > 0.0) {
            log.warn((Object)("Attempt to set positive down-regulation capacity " + filteredValue));
            return;
        }
        this.downRegulationCapacity = filteredValue;
    }

    public void add(RegulationCapacity rc) {
        this.setUpRegulationCapacity(this.upRegulationCapacity + rc.upRegulationCapacity);
        this.setDownRegulationCapacity(this.downRegulationCapacity + rc.downRegulationCapacity);
    }

    public void addUpRegulation(double amount) {
        if (amount < 0.0) {
            log.warn((Object)("Attempt to add negative up-regulation capacity " + amount));
            return;
        }
        this.setUpRegulationCapacity(this.upRegulationCapacity + amount);
    }

    public void addDownRegulation(double amount) {
        if (amount > 0.0) {
            log.warn((Object)("Attempt to add positive down-regulation capacity " + amount));
            return;
        }
        this.setDownRegulationCapacity(this.downRegulationCapacity + amount);
    }

    private double filterValue(double original) {
        if (Math.abs(original) < epsilon) {
            return 0.0;
        }
        return original;
    }
}

