/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.util.ListTools;
import org.powertac.util.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TariffSubscriptionRepo
implements DomainRepo {
    private HashMap<Tariff, List<TariffSubscription>> tariffMap = new HashMap();
    private HashMap<CustomerInfo, List<TariffSubscription>> customerMap = new HashMap();
    @Autowired
    private TariffRepo tariffRepo;

    public TariffSubscription getSubscription(CustomerInfo customer, Tariff tariff) {
        TariffSubscription result = this.findSubscriptionForCustomer(this.tariffMap.get(tariff), customer);
        if (result != null) {
            return result;
        }
        result = new TariffSubscription(customer, tariff);
        this.storeSubscription(result, customer, tariff);
        return result;
    }

    public List<TariffSubscription> findSubscriptionsForTariff(Tariff tariff) {
        List<TariffSubscription> result = this.tariffMap.get(tariff);
        if (result == null) {
            return new ArrayList<TariffSubscription>();
        }
        return new ArrayList<TariffSubscription>(result);
    }

    public List<TariffSubscription> findSubscriptionsForCustomer(CustomerInfo customer) {
        List<TariffSubscription> result = this.customerMap.get(customer);
        if (result == null) {
            return new ArrayList<TariffSubscription>();
        }
        return new ArrayList<TariffSubscription>(result);
    }

    public List<TariffSubscription> findActiveSubscriptionsForCustomer(CustomerInfo customer) {
        ArrayList<TariffSubscription> result = new ArrayList<TariffSubscription>();
        for (TariffSubscription sub : this.findSubscriptionsForCustomer(customer)) {
            if (sub.getCustomersCommitted() <= 0) continue;
            result.add(sub);
        }
        return result;
    }

    public TariffSubscription add(TariffSubscription subscription) {
        this.storeSubscription(subscription, subscription.getCustomer(), subscription.getTariff());
        return subscription;
    }

    public TariffSubscription findSubscriptionForTariffAndCustomer(Tariff tariff, CustomerInfo customer) {
        List<TariffSubscription> subs = this.findSubscriptionsForTariff(tariff);
        if (subs == null) {
            return null;
        }
        for (TariffSubscription sub : subs) {
            if (sub.getCustomer() != customer) continue;
            return sub;
        }
        return null;
    }

    public List<TariffSubscription> getRevokedSubscriptionList(CustomerInfo customer) {
        if (this.customerMap.get(customer) == null) {
            return new ArrayList<TariffSubscription>();
        }
        List<TariffSubscription> result = ListTools.filter((Collection)this.customerMap.get(customer), new Predicate<TariffSubscription>(){

            @Override
            public boolean apply(TariffSubscription sub) {
                return TariffSubscriptionRepo.this.tariffRepo.findTariffById(sub.getTariff().getId()) != null && sub.getTariff().getState() == Tariff.State.KILLED && sub.getCustomersCommitted() > 0;
            }
        });
        return result;
    }

    public void removeSubscriptionsForTariff(Tariff tariff) {
        List<TariffSubscription> subs = this.tariffMap.get(tariff);
        if (subs == null) {
            return;
        }
        for (TariffSubscription sub : subs) {
            this.customerMap.get(sub.getCustomer()).remove(sub);
        }
        this.tariffMap.remove(tariff);
    }

    @Override
    public void recycle() {
        this.tariffMap.clear();
        this.customerMap.clear();
    }

    private TariffSubscription findSubscriptionForCustomer(List<TariffSubscription> subs, CustomerInfo customer) {
        if (subs == null) {
            return null;
        }
        for (TariffSubscription sub : subs) {
            if (sub.getCustomer() != customer) continue;
            return sub;
        }
        return null;
    }

    private void storeSubscription(TariffSubscription subscription, CustomerInfo customer, Tariff tariff) {
        if (this.tariffMap.get(tariff) == null) {
            this.tariffMap.put(tariff, new ArrayList());
        }
        this.tariffMap.get(tariff).add(subscription);
        if (this.customerMap.get(customer) == null) {
            this.customerMap.put(customer, new ArrayList());
        }
        this.customerMap.get(customer).add(subscription);
    }
}

