/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.base.AbstractInstant;
import org.powertac.common.HourlyCharge;
import org.powertac.common.IdGenerator;
import org.powertac.common.RateCore;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TimeService;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain(fields={"tariffId", "weeklyBegin", "weeklyEnd", "dailyBegin", "dailyEnd", "tierThreshold", "fixed", "minValue", "maxValue", "noticeInterval", "expectedMean", "maxCurtailment"})
@XStreamAlias(value="rate")
public class Rate
extends RateCore {
    private static Logger log;
    @XStreamAsAttribute
    private int weeklyBegin;
    @XStreamAsAttribute
    private int weeklyEnd;
    @XStreamAsAttribute
    private int dailyBegin;
    @XStreamAsAttribute
    private int dailyEnd;
    @XStreamAsAttribute
    private double tierThreshold;
    @XStreamAsAttribute
    private boolean fixed;
    @XStreamAsAttribute
    private double minValue;
    @XStreamAsAttribute
    private double maxValue;
    @XStreamAsAttribute
    private long noticeInterval;
    @XStreamAsAttribute
    private double expectedMean;
    @XStreamAsAttribute
    private double maxCurtailment;
    private TreeSet<HourlyCharge> rateHistory;
    @XStreamOmitField
    private ProbeCharge probe;
    @XStreamOmitField
    private TimeService timeService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        Factory factory = new Factory("Rate.java", Class.forName("org.powertac.common.Rate"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Rate", "", "", ""), 140);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withWeeklyBegin", "org.powertac.common.Rate", "int:", "begin:", "", "org.powertac.common.Rate"), 176);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMaxCurtailment", "org.powertac.common.Rate", "double:", "value:", "", "org.powertac.common.Rate"), 460);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withFixed", "org.powertac.common.Rate", "boolean:", "fixed:", "", "org.powertac.common.Rate"), 475);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withExpectedMean", "org.powertac.common.Rate", "double:", "value:", "", "org.powertac.common.Rate"), 501);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withValue", "org.powertac.common.Rate", "double:", "value:", "", "org.powertac.common.Rate"), 595);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withWeeklyEnd", "org.powertac.common.Rate", "int:", "end:", "", "org.powertac.common.Rate"), 216);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDailyBegin", "org.powertac.common.Rate", "int:", "begin:", "", "org.powertac.common.Rate"), 254);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDailyEnd", "org.powertac.common.Rate", "int:", "end:", "", "org.powertac.common.Rate"), 292);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withNoticeInterval", "org.powertac.common.Rate", "long:", "hours:", "", "org.powertac.common.Rate"), 318);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addHourlyCharge", "org.powertac.common.Rate", "org.powertac.common.HourlyCharge:boolean:", "newCharge:publish:", "", "boolean"), 347);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTierThreshold", "org.powertac.common.Rate", "double:", "tierThreshold:", "", "org.powertac.common.Rate"), 405);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinValue", "org.powertac.common.Rate", "double:", "minValue:", "", "org.powertac.common.Rate"), 422);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMaxValue", "org.powertac.common.Rate", "double:", "maxValue:", "", "org.powertac.common.Rate"), 439);
        log = Logger.getLogger((String)Rate.class.getName());
    }

    public Rate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        this.weeklyBegin = -1;
        this.weeklyEnd = -1;
        this.dailyBegin = -1;
        this.dailyEnd = -1;
        this.tierThreshold = 0.0;
        this.fixed = true;
        this.minValue = 0.0;
        this.maxValue = 0.0;
        this.noticeInterval = 0L;
        this.expectedMean = 0.0;
        this.maxCurtailment = 0.0;
        this.timeService = null;
        this.rateHistory = new TreeSet();
        this.probe = new ProbeCharge(new Instant(0L), 0.0);
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public Rate withWeeklyBegin(AbstractDateTime begin) {
        if (begin != null) {
            return this.withWeeklyBegin(begin.getDayOfWeek());
        }
        return this;
    }

    public Rate withWeeklyBegin(ReadablePartial begin) {
        if (begin != null) {
            return this.withWeeklyBegin(begin.get(DateTimeFieldType.dayOfWeek()));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withWeeklyBegin(int n) {
        void begin;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.weeklyBegin = begin;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getWeeklyBegin() {
        return this.weeklyBegin;
    }

    public Rate withWeeklyEnd(AbstractDateTime end) {
        if (end != null) {
            return this.withWeeklyEnd(end.getDayOfWeek());
        }
        return this;
    }

    public Rate withWeeklyEnd(ReadablePartial end) {
        if (end != null) {
            return this.withWeeklyEnd(end.get(DateTimeFieldType.dayOfWeek()));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withWeeklyEnd(int n) {
        void end;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.weeklyEnd = end;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getWeeklyEnd() {
        return this.weeklyEnd;
    }

    public Rate withDailyBegin(AbstractDateTime begin) {
        if (begin != null) {
            return this.withDailyBegin(begin.getHourOfDay());
        }
        return this;
    }

    public Rate withDailyBegin(ReadablePartial begin) {
        if (begin != null) {
            return this.withDailyBegin(begin.get(DateTimeFieldType.hourOfDay()));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withDailyBegin(int n) {
        void begin;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.dailyBegin = begin;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getDailyBegin() {
        return this.dailyBegin;
    }

    public Rate withDailyEnd(AbstractDateTime end) {
        if (end != null) {
            return this.withDailyEnd(end.getHourOfDay());
        }
        return this;
    }

    public Rate withDailyEnd(ReadablePartial end) {
        if (end != null) {
            return this.withDailyEnd(end.get(DateTimeFieldType.hourOfDay()));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withDailyEnd(int n) {
        void end;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        this.dailyEnd = end;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getDailyEnd() {
        return this.dailyEnd;
    }

    public Rate withNoticeInterval(Duration interval) {
        return this.withNoticeInterval(interval.getMillis() / 3600000L);
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withNoticeInterval(long l) {
        void hours;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        this.noticeInterval = hours;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public long getNoticeInterval() {
        return this.noticeInterval;
    }

    public boolean addHourlyCharge(HourlyCharge newCharge) {
        return this.addHourlyCharge(newCharge, false);
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public boolean addHourlyCharge(HourlyCharge hourlyCharge, boolean bl) {
        HourlyCharge hourlyCharge2 = hourlyCharge;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)hourlyCharge2, (Object)Conversions.booleanObject((boolean)bl2));
        boolean result = false;
        if (this.fixed) {
            log.error((Object)("Cannot change Rate " + this.toString()));
        } else {
            void publish;
            void newCharge;
            Instant now = this.getCurrentTime();
            double sgn = Math.signum(this.maxValue);
            long warning = newCharge.getAtTime().getMillis() - now.getMillis();
            if (warning < this.noticeInterval * 3600000L && publish == false) {
                log.warn((Object)("Too late (" + now.toString() + ") to change rate for " + newCharge.getAtTime().toString()));
            } else if (sgn * newCharge.getValue() > sgn * this.maxValue) {
                log.warn((Object)("Excess charge: " + newCharge.getValue() + " > " + this.maxValue));
            } else if (sgn * newCharge.getValue() < sgn * this.minValue) {
                log.warn((Object)("Charge too low: " + newCharge.getValue() + " < " + this.minValue));
            } else {
                HourlyCharge item;
                if (this.probe == null) {
                    this.probe = new ProbeCharge(new Instant(0L), 0.0);
                }
                this.probe.setAtTime(newCharge.getAtTime().plus(1000L));
                SortedSet<HourlyCharge> head = this.rateHistory.headSet(this.probe);
                if (head != null && head.size() > 0 && (item = head.last()).getAtTime() == newCharge.getAtTime()) {
                    log.debug((Object)("remove " + item.toString()));
                    this.rateHistory.remove(item);
                }
                newCharge.setRateId(this.getId());
                this.rateHistory.add((HourlyCharge)newCharge);
                log.info((Object)("Adding HourlyCharge " + newCharge.getId() + " at " + newCharge.getAtTime() + " to " + this.toString()));
                result = true;
            }
        }
        boolean bl3 = result;
        StateLogging.aspectOf().setstate(joinPoint);
        return bl3;
    }

    public double getTierThreshold() {
        return this.tierThreshold;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withTierThreshold(double d) {
        void tierThreshold;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.tierThreshold = tierThreshold;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getMinValue() {
        return this.minValue;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withMinValue(double d) {
        void minValue;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.minValue = minValue;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withMaxValue(double d) {
        void maxValue;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.maxValue = maxValue;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getMaxCurtailment() {
        return this.maxCurtailment;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withMaxCurtailment(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.maxCurtailment = Math.min(1.0, Math.max(0.0, (double)value));
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withFixed(boolean bl) {
        void fixed;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        this.fixed = fixed;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public boolean isTimeOfUse() {
        return this.dailyBegin >= 0 || this.weeklyBegin >= 0;
    }

    public double getExpectedMean() {
        return this.expectedMean;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withExpectedMean(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.expectedMean = value;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public TreeSet<HourlyCharge> getRateHistory() {
        return this.rateHistory;
    }

    public boolean applies() {
        return this.applies((AbstractInstant)this.getCurrentTime());
    }

    public boolean applies(AbstractInstant when) {
        boolean appliesWeekly = false;
        boolean appliesDaily = false;
        DateTime time = new DateTime((Object)when, DateTimeZone.UTC);
        int day = time.getDayOfWeek();
        appliesWeekly = this.weeklyBegin == -1 ? true : (this.weeklyEnd == -1 ? day == this.weeklyBegin : (this.weeklyEnd >= this.weeklyBegin ? day >= this.weeklyBegin && day <= this.weeklyEnd : day >= this.weeklyBegin || day <= this.weeklyEnd));
        int hour = time.getHourOfDay();
        if (this.dailyBegin == -1 || this.dailyEnd == -1) {
            appliesDaily = true;
        } else if (this.dailyEnd > this.dailyBegin) {
            appliesDaily = hour >= this.dailyBegin && hour < this.dailyEnd;
        } else {
            boolean bl = appliesDaily = hour >= this.dailyBegin || hour < this.dailyEnd;
        }
        return appliesWeekly && appliesDaily;
    }

    public boolean applies(double usage) {
        return this.applies(usage, (AbstractInstant)this.getCurrentTime());
    }

    public boolean applies(double usage, AbstractInstant when) {
        if (usage >= this.tierThreshold) {
            return this.applies(when);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Rate withValue(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2));
        this.minValue = value;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getValue() {
        return this.getValue((AbstractInstant)this.getCurrentTime(), null);
    }

    public double getValue(AbstractInstant when) {
        return this.getValue(when, null);
    }

    public double getValue(AbstractInstant when, TariffEvaluationHelper helper) {
        if (this.fixed) {
            return this.minValue;
        }
        if (helper != null) {
            return helper.getWeightedValue(this);
        }
        if (this.rateHistory.size() == 0) {
            log.debug((Object)"no rate history, return default");
            return this.expectedMean;
        }
        if (this.probe == null) {
            this.probe = new ProbeCharge(new Instant(0L), 0.0);
        }
        Instant inst = new Instant((Object)when);
        this.probe.setAtTime(inst.plus(1000L));
        SortedSet<HourlyCharge> head = this.rateHistory.headSet(this.probe);
        if (head == null || head.size() == 0) {
            log.debug((Object)("No hourly charge found for " + when.getMillis() + ", returning default"));
            return this.expectedMean;
        }
        HourlyCharge candidate = head.last();
        if (candidate.getAtTime().getMillis() == inst.getMillis()) {
            return candidate.getValue();
        }
        return this.expectedMean;
    }

    public boolean isValid(TariffSpecification spec) {
        double sgn;
        if (Double.isNaN(this.minValue) || Double.isNaN(this.maxValue) || Double.isNaN(this.expectedMean)) {
            log.warn((Object)("numeric insanity: (" + this.minValue + "," + this.maxValue + "," + this.expectedMean + ")"));
            return false;
        }
        if (Double.isInfinite(this.minValue) || Double.isInfinite(this.maxValue) || Double.isInfinite(this.expectedMean)) {
            log.warn((Object)("Infinite value: (" + this.minValue + "," + this.maxValue + "," + this.expectedMean + ")"));
            return false;
        }
        if (Double.isNaN(this.maxCurtailment) || this.maxCurtailment < 0.0 || this.maxCurtailment > 1.0) {
            log.warn((Object)("Curtailment ratio " + this.maxCurtailment + " out of range"));
            return false;
        }
        if (Double.isNaN(this.tierThreshold) || spec.getPowerType().isConsumption() && this.tierThreshold < 0.0) {
            log.warn((Object)"Negative tier threshold for consumption rate");
            return false;
        }
        if (Double.isNaN(this.tierThreshold) || spec.getPowerType().isProduction() && this.tierThreshold > 0.0) {
            log.warn((Object)"Positive tier threshold for production rate");
            return false;
        }
        if (this.isFixed()) {
            return true;
        }
        double d = sgn = spec.getPowerType().isConsumption() ? -1.0 : 1.0;
        if (sgn * this.maxValue < sgn * this.minValue) {
            log.warn((Object)("maxValue " + this.maxValue + " out of range"));
            return false;
        }
        if (sgn * this.expectedMean < sgn * this.minValue || sgn * this.expectedMean > sgn * this.maxValue) {
            log.warn((Object)("expectedMean " + this.expectedMean + " out of range"));
            return false;
        }
        if (this.noticeInterval < 0L) {
            log.warn((Object)("negative notice interval " + this.noticeInterval));
            return false;
        }
        return true;
    }

    public String toString() {
        String result = "Rate." + IdGenerator.getString(this.getId()) + ":";
        result = this.fixed ? String.valueOf(result) + " Fixed " + this.getMinValue() : String.valueOf(result) + " Variable";
        if (this.weeklyBegin >= 0) {
            result = String.valueOf(result) + ", " + (this.weeklyEnd >= 0 ? "starts " : "") + "day" + this.weeklyBegin;
            if (this.weeklyEnd >= 0) {
                result = String.valueOf(result) + " ends day " + this.weeklyEnd;
            }
        }
        if (this.dailyBegin >= 0) {
            result = String.valueOf(result) + ", " + this.dailyBegin + ":00 -- " + this.dailyEnd + ":00";
        }
        if (this.tierThreshold > 0.0) {
            result = String.valueOf(result) + ", usage > " + this.tierThreshold;
        }
        return result;
    }

    private Instant getCurrentTime() {
        if (this.timeService == null) {
            this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        }
        return this.timeService.getCurrentTime();
    }

    void setTimeService(TimeService service) {
        this.timeService = service;
    }

    class ProbeCharge
    extends HourlyCharge {
        public ProbeCharge(Instant when, double charge) {
            super(when, charge);
        }

        void setAtTime(Instant when) {
            this.atTime = when;
        }
    }
}

