/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TimeService;
import org.powertac.common.interfaces.BootstrapState;
import org.powertac.common.interfaces.CustomerServiceAccessor;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.customer.AbstractCustomer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerModelService
extends TimeslotPhaseProcessor
implements InitializationService,
BootstrapState,
NewTariffListener,
CustomerServiceAccessor {
    private static Logger log = Logger.getLogger((String)CustomerModelService.class.getName());
    @Autowired
    private TimeService timeService;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private ServerConfiguration serverConfig;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    private TariffMarket tariffMarketService;
    private ArrayList<AbstractCustomer> models;

    @Override
    public void setDefaults() {
    }

    @Override
    public String initialize(Competition competition, List<String> completedInits) {
        if (!completedInits.contains("DefaultBroker") || !completedInits.contains("TariffMarket")) {
            return null;
        }
        super.init();
        this.models = new ArrayList();
        ServiceLoader<AbstractCustomer> loader = ServiceLoader.load(AbstractCustomer.class);
        for (AbstractCustomer modelEx : loader) {
            for (Object modelObj : this.serverConfig.configureInstances(modelEx.getClass())) {
                AbstractCustomer model = (AbstractCustomer)modelObj;
                log.info((Object)("Adding model " + model.getName()));
                this.models.add(model);
                model.setServiceAccessor(this);
                model.initialize();
                for (CustomerInfo cust : model.getCustomerInfos()) {
                    this.tariffMarketService.subscribeToTariff(this.tariffMarketService.getDefaultTariff(cust.getPowerType()), cust, cust.getPopulation());
                    this.customerRepo.add(cust);
                }
            }
        }
        return "Customer";
    }

    @Override
    public void activate(Instant time, int phaseNumber) {
        for (AbstractCustomer model : this.models) {
            log.info((Object)("Step model " + model.getName()));
            model.step();
        }
    }

    @Override
    public void publishNewTariffs(List<Tariff> tariffs) {
        for (AbstractCustomer model : this.models) {
            log.info((Object)("Evaluating tariffs for " + model.getName()));
            model.evaluateTariffs(tariffs);
        }
    }

    List<AbstractCustomer> getModelList() {
        return this.models;
    }

    @Override
    public void saveBootstrapState() {
        this.serverConfig.saveBootstrapState(this.models);
        for (AbstractCustomer model : this.models) {
            model.saveBootstrapState();
        }
    }

    @Override
    public CustomerRepo getCustomerRepo() {
        return this.customerRepo;
    }

    @Override
    public RandomSeedRepo getRandomSeedRepo() {
        return this.randomSeedRepo;
    }

    @Override
    public TariffRepo getTariffRepo() {
        return this.tariffRepo;
    }

    @Override
    public TariffSubscriptionRepo getTariffSubscriptionRepo() {
        return this.tariffSubscriptionRepo;
    }

    @Override
    public TimeslotRepo getTimeslotRepo() {
        return this.timeslotRepo;
    }

    @Override
    public TimeService getTimeService() {
        return this.timeService;
    }

    @Override
    public WeatherReportRepo getWeatherReportRepo() {
        return this.weatherReportRepo;
    }

    @Override
    public ServerConfiguration getServerConfiguration() {
        return this.serverConfig;
    }
}

