/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import org.powertac.common.BalancingTransaction;
import org.powertac.common.BankTransaction;
import org.powertac.common.Broker;
import org.powertac.common.CashPosition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.DistributionTransaction;
import org.powertac.common.MarketTransaction;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(value="singleton")
@Service
public class TransactionFactory {
    @Autowired
    private TimeslotRepo timeslotRepo;

    private int getTimeslotIndex() {
        return this.timeslotRepo.currentSerialNumber();
    }

    public BankTransaction makeBankTransaction(Broker broker, double amount) {
        return new BankTransaction(broker, amount, this.getTimeslotIndex());
    }

    public BalancingTransaction makeBalancingTransaction(Broker broker, double kWh, double charge) {
        return new BalancingTransaction(broker, this.getTimeslotIndex(), kWh, charge);
    }

    public CashPosition makeCashPosition(Broker broker, double balance) {
        return new CashPosition(broker, balance, this.getTimeslotIndex());
    }

    public DistributionTransaction makeDistributionTransaction(Broker broker, double kWh, double charge) {
        return new DistributionTransaction(broker, this.getTimeslotIndex(), kWh, charge);
    }

    public MarketTransaction makeMarketTransaction(Broker broker, Timeslot timeslot, double mWh, double price) {
        return new MarketTransaction(broker, this.getTimeslotIndex(), timeslot, mWh, price);
    }

    public TariffTransaction makeTariffTransaction(Broker broker, TariffTransaction.Type txType, TariffSpecification spec, CustomerInfo customer, int customerCount, double kWh, double charge) {
        return new TariffTransaction(broker, this.getTimeslotIndex(), txType, spec, customer, customerCount, kWh, charge);
    }
}

