/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;

@Domain
@XStreamAlias(value="weather-report")
public class WeatherReport {
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private int currentTimeslot;
    @XStreamAsAttribute
    private double temperature;
    @XStreamAsAttribute
    private double windSpeed;
    @XStreamAsAttribute
    private double windDirection;
    @XStreamAsAttribute
    private double cloudCover;
    private static TimeslotRepo timeslotRepo;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public WeatherReport(int timeslot, double temperature, double windSpeed, double windDirection, double cloudCover) {
        int n = timeslot;
        double d = temperature;
        double d2 = windSpeed;
        double d3 = windDirection;
        double d4 = cloudCover;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), Conversions.doubleObject((double)d3), Conversions.doubleObject((double)d4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        this.id = IdGenerator.createId();
        this.currentTimeslot = timeslot;
        this.temperature = temperature;
        this.windSpeed = windSpeed;
        this.windDirection = windDirection;
        this.cloudCover = cloudCover;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    @Deprecated
    @ChainedConstructor
    public WeatherReport(Timeslot timeslot, double temperature, double windSpeed, double windDirection, double cloudCover) {
        this(timeslot.getSerialNumber(), temperature, windSpeed, windDirection, cloudCover);
    }

    public long getId() {
        return this.id;
    }

    public int getTimeslotIndex() {
        return this.currentTimeslot;
    }

    @Deprecated
    public Timeslot getCurrentTimeslot() {
        return WeatherReport.getTimeslotRepo().findBySerialNumber(this.currentTimeslot);
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getWindSpeed() {
        return this.windSpeed;
    }

    public double getWindDirection() {
        return this.windDirection;
    }

    public double getCloudCover() {
        return this.cloudCover;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (timeslotRepo == null) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }

    static {
        Factory factory = new Factory("WeatherReport.java", Class.forName("org.powertac.common.WeatherReport"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.WeatherReport", "int:double:double:double:double:", "timeslot:temperature:windSpeed:windDirection:cloudCover:", ""), 61);
    }
}

