/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.spring.SpringApplicationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

@Service
public class XMLMessageConverter {
    private static final Logger log = LogManager.getLogger(XMLMessageConverter.class);
    private Class[] commandClasses = new Class[]{CustomerBootstrapData.class, SimEnd.class, SimStart.class, SimPause.class, SimResume.class};
    private XStream xstream;
    @Autowired
    private SpringApplicationContext context;

    @PostConstruct
    public void afterPropertiesSet() {
        this.xstream = new XStream();
        try {
            List<Class> classes = this.findMyTypes("org.powertac.common");
            for (Class clazz : classes) {
                log.info("processing class " + clazz.getName());
                this.xstream.processAnnotations(clazz);
            }
        }
        catch (IOException e) {
            log.error("failed to process annotation", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("failed to process annotation", (Throwable)e);
        }
        for (Class commandClazz : this.commandClasses) {
            this.xstream.processAnnotations(commandClazz);
        }
        this.xstream.autodetectAnnotations(true);
        this.xstream.aliasSystemAttribute(null, "class");
    }

    public String toXML(Object message) {
        return this.xstream.toXML(message);
    }

    public Object fromXML(String xml) {
        return this.xstream.fromXML(xml);
    }

    private List<Class> findMyTypes(String basePackage) throws IOException, ClassNotFoundException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        ArrayList<Class> candidates = new ArrayList<Class>();
        String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + "/" + "**/*.class";
        for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
            if (!resource.isReadable()) continue;
            MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
            candidates.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
        }
        return candidates;
    }

    private String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }
}

