/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.IdGenerator;
import org.powertac.common.RegulationCapacity;

public class RegulationAccumulator {
    protected static Logger log = LogManager.getLogger((String)RegulationAccumulator.class.getName());
    long id = IdGenerator.createId();
    private static double epsilon = 1.0E-4;
    private double upRegulationCapacity = 0.0;
    private double downRegulationCapacity = 0.0;

    public RegulationAccumulator(double upRegulationCapacity, double downRegulationCapacity) {
        if (upRegulationCapacity < 0.0 && (upRegulationCapacity = 0.0) < -1.0E-12) {
            log.warn("upRegulationCapacity " + upRegulationCapacity + " < 0.0");
        }
        if (downRegulationCapacity > 0.0 && (downRegulationCapacity = 0.0) > 1.0E-12) {
            log.warn("downRegulationCapacity " + downRegulationCapacity + " > 0.0");
        }
        this.upRegulationCapacity = upRegulationCapacity;
        this.downRegulationCapacity = downRegulationCapacity;
    }

    public RegulationAccumulator(RegulationCapacity rc) {
        this.upRegulationCapacity = rc.getUpRegulationCapacity();
        this.downRegulationCapacity = rc.getDownRegulationCapacity();
    }

    public long getId() {
        return this.id;
    }

    public double getUpRegulationCapacity() {
        return this.upRegulationCapacity;
    }

    public void setUpRegulationCapacity(double value) {
        double filteredValue = this.filterValue(value);
        if (filteredValue < 0.0) {
            log.warn("Attempt to set negative up-regulation capacity " + filteredValue);
            return;
        }
        this.upRegulationCapacity = filteredValue;
    }

    public double getDownRegulationCapacity() {
        return this.downRegulationCapacity;
    }

    public void setDownRegulationCapacity(double value) {
        double filteredValue = this.filterValue(value);
        if (filteredValue > 0.0) {
            log.warn("Attempt to set positive down-regulation capacity " + filteredValue);
            return;
        }
        this.downRegulationCapacity = filteredValue;
    }

    public void add(RegulationAccumulator rc) {
        this.setUpRegulationCapacity(this.upRegulationCapacity + rc.upRegulationCapacity);
        this.setDownRegulationCapacity(this.downRegulationCapacity + rc.downRegulationCapacity);
    }

    public void addUpRegulation(double amount) {
        if (amount < 0.0) {
            log.warn("Attempt to add negative up-regulation capacity " + amount);
            return;
        }
        this.setUpRegulationCapacity(this.upRegulationCapacity + amount);
    }

    public void addDownRegulation(double amount) {
        if (amount > 0.0) {
            log.warn("Attempt to add positive down-regulation capacity " + amount);
            return;
        }
        this.setDownRegulationCapacity(this.downRegulationCapacity + amount);
    }

    private double filterValue(double original) {
        if (Math.abs(original) < epsilon) {
            return 0.0;
        }
        return original;
    }
}

