/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.IdGenerator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.state.Domain;

@Domain(fields={"subscription", "upRegulationCapacity", "downRegulationCapacity"})
public class RegulationCapacity {
    protected static Logger log = LogManager.getLogger((String)RegulationCapacity.class.getName());
    long id = IdGenerator.createId();
    private static double epsilon = 1.0E-10;
    private TariffSubscription subscription = null;
    private double upRegulationCapacity = 0.0;
    private double downRegulationCapacity = 0.0;

    public RegulationCapacity(TariffSubscription subscription, double upRegulationCapacity, double downRegulationCapacity) {
        this.subscription = subscription;
        if (upRegulationCapacity < 0.0) {
            if (upRegulationCapacity < -epsilon) {
                log.warn("upRegulationCapacity " + upRegulationCapacity + " < 0.0");
            }
            upRegulationCapacity = 0.0;
        }
        if (downRegulationCapacity > 0.0) {
            if (downRegulationCapacity > epsilon) {
                log.warn("downRegulationCapacity " + downRegulationCapacity + " > 0.0");
            }
            downRegulationCapacity = 0.0;
        }
        this.upRegulationCapacity = upRegulationCapacity;
        this.downRegulationCapacity = downRegulationCapacity;
    }

    public RegulationCapacity() {
    }

    public long getId() {
        return this.id;
    }

    public TariffSubscription getSubscription() {
        return this.subscription;
    }

    public double getUpRegulationCapacity() {
        return this.upRegulationCapacity;
    }

    public double getDownRegulationCapacity() {
        return this.downRegulationCapacity;
    }
}

