/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.RegulationAccumulator;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain
public class TariffSubscription {
    private static Logger log = LogManager.getLogger((String)TariffSubscription.class.getName());
    long id = IdGenerator.createId();
    private TimeService timeService;
    private Accounting accountingService;
    private TariffMarket tariffMarketService;
    private CustomerInfo customer;
    private Tariff tariff;
    private long tariffId;
    private int customersCommitted = 0;
    private List<ExpirationRecord> expirations;
    private double totalUsage = 0.0;
    private int pendingUnsubscribeCount = 0;
    private double pendingRegulationRatio = 0.0;
    RegulationAccumulator regulationAccumulator;
    private double regulation = 0.0;

    public TariffSubscription(CustomerInfo customer, Tariff tariff) {
        this.customer = customer;
        this.tariff = tariff;
        this.tariffId = tariff.getId();
        this.expirations = new ArrayList<ExpirationRecord>();
        this.setRegulationCap(new RegulationAccumulator(0.0, 0.0));
    }

    public TariffSubscription(CustomerInfo customer, long tariffId) {
        this.customer = customer;
        this.tariffId = tariffId;
        this.expirations = new ArrayList<ExpirationRecord>();
        this.setRegulationCap(new RegulationAccumulator(0.0, 0.0));
    }

    public long getId() {
        return this.id;
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public Tariff getTariff() {
        return this.tariff;
    }

    public long getTariffId() {
        return this.tariffId;
    }

    public int getCustomersCommitted() {
        return this.customersCommitted;
    }

    @StateChange
    public void setCustomersCommitted(int value) {
        this.customersCommitted = value;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    @StateChange
    public void subscribe(int customerCount) {
        this.setCustomersCommitted(this.getCustomersCommitted() + customerCount);
        long minDuration = this.tariff.getMinDuration();
        Instant start = this.getTimeService().getCurrentTime();
        if (this.expirations.size() > 0 && this.expirations.get(this.expirations.size() - 1).getHorizon() == start.getMillis() + minDuration) {
            this.expirations.get(this.expirations.size() - 1).updateCount(customerCount);
        } else {
            this.expirations.add(new ExpirationRecord(start.getMillis() + minDuration, customerCount));
        }
        if (this.tariff.getSignupPayment() != 0.0) {
            log.debug("signup bonus: " + customerCount + " customers, total = " + (double)customerCount * this.tariff.getSignupPayment());
        }
        this.getAccounting().addTariffTransaction(TariffTransaction.Type.SIGNUP, this.tariff, this.customer, customerCount, 0.0, (double)customerCount * -this.tariff.getSignupPayment());
    }

    public void unsubscribe(int customerCount) {
        this.getTariffMarket().subscribeToTariff(this.getTariff(), this.getCustomer(), -customerCount);
        this.pendingUnsubscribeCount += customerCount;
    }

    @StateChange
    public void deferredUnsubscribe(int customerCount) {
        this.pendingUnsubscribeCount = 0;
        if (customerCount == this.customersCommitted) {
            this.setRegulationCap(new RegulationAccumulator(0.0, 0.0));
            this.setRegulation(0.0);
        }
        if (customerCount > this.customersCommitted) {
            log.error("tariff " + this.tariff.getId() + " customer " + this.customer.getName() + ": attempt to unsubscribe " + customerCount + " from subscription of " + this.customersCommitted);
            customerCount = this.customersCommitted;
        }
        int freeAgentCount = this.getExpiredCustomerCount();
        int penaltyCount = Math.max(customerCount - freeAgentCount, 0);
        int expCount = customerCount;
        while (expCount > 0 && this.expirations.get(0) != null) {
            int cec = this.expirations.get(0).getCount();
            if (cec <= expCount) {
                expCount -= cec;
                this.expirations.remove(0);
                continue;
            }
            this.expirations.get(0).updateCount(-expCount);
            expCount = 0;
        }
        this.setCustomersCommitted(this.getCustomersCommitted() - customerCount);
        if (0 == this.getCustomersCommitted()) {
            this.regulationAccumulator.setDownRegulationCapacity(0.0);
            this.regulationAccumulator.setUpRegulationCapacity(0.0);
        }
        double withdrawPayment = -this.tariff.getEarlyWithdrawPayment();
        if (this.tariff.isRevoked()) {
            withdrawPayment = 0.0;
        }
        this.getAccounting().addTariffTransaction(TariffTransaction.Type.WITHDRAW, this.tariff, this.customer, customerCount, 0.0, (double)penaltyCount * withdrawPayment);
        if (this.tariff.getSignupPayment() < 0.0) {
            this.getAccounting().addTariffTransaction(TariffTransaction.Type.REFUND, this.tariff, this.customer, customerCount, 0.0, (double)customerCount * this.tariff.getSignupPayment());
        }
    }

    public Tariff handleRevokedTariff() {
        if (!this.tariff.isRevoked()) {
            log.warn("Tariff " + this.tariff.getId() + " is not revoked.");
            return this.tariff;
        }
        if (0 == this.customersCommitted) {
            return null;
        }
        Tariff newTariff = null;
        if (newTariff == null) {
            newTariff = this.getTariffMarket().getDefaultTariff(this.tariff.getTariffSpec().getPowerType());
        }
        if (newTariff == null) {
            newTariff = this.getTariffMarket().getDefaultTariff(this.tariff.getTariffSpec().getPowerType().getGenericType());
        }
        this.getTariffMarket().subscribeToTariff(this.tariff, this.customer, -this.customersCommitted);
        this.getTariffMarket().subscribeToTariff(newTariff, this.customer, this.customersCommitted);
        log.info("Tariff " + this.tariff.getId() + " superseded by " + newTariff.getId() + " for " + this.customersCommitted + " customers");
        return newTariff;
    }

    public void usePower(double kwh) {
        this.ensureRegulationCapacity();
        double kWhPerMember = kwh / (double)this.customersCommitted;
        double actualKwh = (kWhPerMember - this.getEconomicRegulation(kWhPerMember, this.totalUsage)) * (double)this.customersCommitted;
        log.info("usePower " + kwh + ", actual " + actualKwh + ", customer=" + this.customer.getName());
        TariffTransaction.Type txType = actualKwh < 0.0 ? TariffTransaction.Type.PRODUCE : TariffTransaction.Type.CONSUME;
        this.getAccounting().addTariffTransaction(txType, this.tariff, this.customer, this.customersCommitted, -actualKwh, (double)this.customersCommitted * -this.tariff.getUsageCharge(actualKwh / (double)this.customersCommitted, this.totalUsage, true));
        if (this.getTimeService().getHourOfDay() == 0) {
            this.totalUsage = 0.0;
        }
        this.totalUsage += actualKwh / (double)this.customersCommitted;
        if (this.tariff.getPeriodicPayment() != 0.0) {
            this.getAccounting().addTariffTransaction(TariffTransaction.Type.PERIODIC, this.tariff, this.customer, this.customersCommitted, 0.0, (double)this.customersCommitted * -this.tariff.getPeriodicPayment() / 24.0);
        }
    }

    public synchronized double getCurtailment() {
        double sgn = 1.0;
        if (this.tariff.getPowerType().isProduction()) {
            sgn = -1.0;
        }
        double result = sgn * Math.max(sgn * this.regulation, 0.0) * (double)this.customersCommitted;
        this.setRegulation(0.0);
        return result;
    }

    public synchronized double getRegulation() {
        double result = this.regulation;
        this.setRegulation(0.0);
        return result;
    }

    public void setRegulation(double newValue) {
        this.regulation = newValue;
    }

    public void setRegulationCapacity(RegulationCapacity capacity) {
        double upRegulation = capacity.getUpRegulationCapacity();
        double downRegulation = capacity.getDownRegulationCapacity();
        this.regulationAccumulator = new RegulationAccumulator(upRegulation, downRegulation);
    }

    void setRegulationCap(RegulationAccumulator capacity) {
        this.regulationAccumulator = capacity;
    }

    public void ensureRegulationCapacity() {
        if (null == this.regulationAccumulator) {
            this.setRegulationCap(new RegulationAccumulator(0.0, 0.0));
        }
    }

    public boolean hasRegulationRate() {
        return this.tariff.hasRegulationRate();
    }

    double getEconomicRegulation(double proposedUsage, double cumulativeUsage) {
        this.setRegulation(0.0);
        double result = 0.0;
        if (this.getTariff().hasRegulationRate()) {
            if (this.pendingRegulationRatio < 0.0) {
                result = -this.pendingRegulationRatio * this.regulationAccumulator.getDownRegulationCapacity();
                this.regulationAccumulator.setDownRegulationCapacity(this.regulationAccumulator.getDownRegulationCapacity() - result);
            } else if (this.pendingRegulationRatio > 1.0) {
                if (this.regulationAccumulator.getUpRegulationCapacity() > proposedUsage) {
                    double excess = this.regulationAccumulator.getUpRegulationCapacity() - proposedUsage;
                    result = proposedUsage + (this.pendingRegulationRatio - 1.0) * excess;
                    this.regulationAccumulator.setUpRegulationCapacity(this.regulationAccumulator.getUpRegulationCapacity() - result);
                }
            } else {
                result = this.pendingRegulationRatio * this.regulationAccumulator.getUpRegulationCapacity();
                this.regulationAccumulator.setUpRegulationCapacity(this.regulationAccumulator.getUpRegulationCapacity() - result);
            }
        } else {
            double proposedUpRegulation = proposedUsage * this.pendingRegulationRatio;
            double mur = this.tariff.getMaxUpRegulation(proposedUsage, cumulativeUsage);
            result = Math.min(proposedUpRegulation, mur);
            log.debug("proposedUpRegulation=" + proposedUpRegulation + ", maxUpRegulation=" + mur);
            this.regulationAccumulator.setUpRegulationCapacity(mur - result);
        }
        if (0.0 != result) {
            log.info("Economic control of {} by {}", (Object)this.customer.getName(), (Object)result);
        }
        this.addRegulation(result);
        this.pendingRegulationRatio = 0.0;
        return result;
    }

    @StateChange
    public synchronized void postRatioControl(double ratio) {
        this.pendingRegulationRatio = ratio;
    }

    @StateChange
    public synchronized void postBalancingControl(double kwh) {
        this.getAccounting().addRegulationTransaction(this.tariff, this.customer, this.customersCommitted, kwh, (double)this.customersCommitted * -this.tariff.getRegulationCharge(-kwh / (double)this.customersCommitted, this.totalUsage, true));
        double kWhPerMember = kwh / (double)this.customersCommitted;
        this.addRegulation(kWhPerMember);
        if (kWhPerMember >= 0.0) {
            this.regulationAccumulator.setUpRegulationCapacity(this.regulationAccumulator.getUpRegulationCapacity() - kWhPerMember);
        } else {
            this.regulationAccumulator.setDownRegulationCapacity(this.regulationAccumulator.getDownRegulationCapacity() - kWhPerMember);
        }
        this.totalUsage -= kWhPerMember;
    }

    public RegulationAccumulator getRemainingRegulationCapacity() {
        if (0 == this.customersCommitted) {
            return new RegulationAccumulator(0.0, 0.0);
        }
        double up = this.regulationAccumulator.getUpRegulationCapacity() * (double)this.customersCommitted;
        double down = this.regulationAccumulator.getDownRegulationCapacity() * (double)this.customersCommitted;
        if (0 == this.pendingUnsubscribeCount) {
            log.info("regulation capacity for " + this.getCustomer().getName() + ":" + this.getTariff().getId() + " (" + up + ", " + down + ")");
            return new RegulationAccumulator(up, down);
        }
        double ratio = (double)(this.customersCommitted - this.pendingUnsubscribeCount) / (double)this.customersCommitted;
        log.info("remaining regulation capacity for " + this.getCustomer().getName() + ":" + this.getTariff().getId() + " reduced by " + ratio + " to (" + up * ratio + ", " + down * ratio + ")");
        return new RegulationAccumulator(up * ratio, down * ratio);
    }

    void addRegulation(double kwh) {
        this.setRegulation(this.regulation + kwh);
    }

    private TimeService getTimeService() {
        if (null == this.timeService) {
            this.timeService = (TimeService)SpringApplicationContext.getBean((String)"timeService");
        }
        return this.timeService;
    }

    private Accounting getAccounting() {
        if (null == this.accountingService) {
            this.accountingService = (Accounting)SpringApplicationContext.getBean((String)"accountingService");
        }
        return this.accountingService;
    }

    private TariffMarket getTariffMarket() {
        if (null == this.tariffMarketService) {
            this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean((String)"tariffMarketService");
        }
        return this.tariffMarketService;
    }

    public int getExpiredCustomerCount() {
        int cc = 0;
        Instant now = this.getTimeService().getCurrentTime();
        for (ExpirationRecord exp : this.expirations) {
            if (exp.getHorizon() > now.getMillis()) continue;
            cc += exp.getCount();
        }
        return cc;
    }

    private class ExpirationRecord {
        private long horizon;
        private int count;

        ExpirationRecord(long horizon, int count) {
            this.horizon = horizon;
            this.count = count;
        }

        long getHorizon() {
            return this.horizon;
        }

        int getCount() {
            return this.count;
        }

        int updateCount(int increment) {
            this.count += increment;
            return this.count;
        }
    }
}

