/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.repo.DomainRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class BootstrapDataRepo
implements DomainRepo {
    private static Logger log = LogManager.getLogger(BootstrapDataRepo.class);
    @Autowired
    private XMLMessageConverter messageConverter;
    private Competition bootstrapCompetition;
    private ArrayList<Object> data = new ArrayList();
    private HashMap<Class<?>, List<Object>> classMap = new HashMap();
    private Properties bootState;

    public void add(Object item) {
        this.data.add(item);
        List<Object> things = this.classMap.get(item.getClass());
        if (null == things) {
            things = new ArrayList<Object>();
            this.classMap.put(item.getClass(), things);
        }
        things.add(item);
    }

    public void add(List<Object> items) {
        for (Object item : items) {
            this.add(item);
        }
    }

    public List<Object> getData() {
        return this.data;
    }

    public List<Object> getData(Class<?> type) {
        return this.classMap.get(type);
    }

    public Competition getBootstrapCompetition() {
        return this.bootstrapCompetition;
    }

    public Properties getBootState() {
        return this.bootState;
    }

    public void recycle() {
        this.data.clear();
        this.classMap.clear();
    }

    public void readBootRecord(URL bootUrl) {
        Document document = this.getDocument(bootUrl);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/config/competition");
            NodeList nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            String xml = this.nodeToString(nodes.item(0));
            this.bootstrapCompetition = (Competition)this.messageConverter.fromXML(xml);
            this.add(this.bootstrapCompetition);
            for (CustomerInfo cust : this.bootstrapCompetition.getCustomers()) {
                this.add(cust);
            }
            exp = xPath.compile("/powertac-bootstrap-data/bootstrap-state/properties");
            nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            if (null != nodes && nodes.getLength() > 0) {
                xml = this.nodeToString(nodes.item(0));
                this.bootState = (Properties)this.messageConverter.fromXML(xml);
            }
        }
        catch (XPathExpressionException xee) {
            log.error("Error reading boot record from {}: {}", (Object)bootUrl, (Object)xee.toString());
            System.out.println("Error reading boot dataset: " + xee.toString());
        }
        this.processBootDataset(document);
    }

    private void processBootDataset(Document document) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/bootstrap/*");
            NodeList nodes = (NodeList)exp.evaluate(document, XPathConstants.NODESET);
            log.info("Found " + nodes.getLength() + " bootstrap nodes");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xml = this.nodeToString(nodes.item(i));
                this.add(this.messageConverter.fromXML(xml));
            }
        }
        catch (XPathExpressionException xee) {
            log.error("runOnce: Error reading config file: " + xee.toString());
        }
    }

    private Document getDocument(URL bootUrl) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream stream = bootUrl.openStream();
            doc = builder.parse(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error("nodeToString Transformer Exception " + te.toString());
        }
        return sw.toString();
    }
}

