/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.RandomSeed;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Service;

@Service
public class RandomSeedRepo
implements DomainRepo {
    private static Logger log = LogManager.getLogger((String)RandomSeedRepo.class.getName());
    private HashMap<String, RandomSeed> seedMap = new HashMap();
    private HashMap<String, Long> pendingSeedMap = new HashMap();

    public RandomSeed getRandomSeed(String classname, long id, String purpose) {
        log.info("Seed requested: " + classname + ";" + id + ";" + purpose);
        String name = this.composeName(classname, id, purpose);
        RandomSeed result = this.seedMap.get(name);
        if (result == null) {
            Long seedValue = this.pendingSeedMap.get(name);
            if (seedValue == null) {
                log.debug("New seed created: " + classname + ";" + id + ";" + purpose);
                result = new RandomSeed(classname, id, purpose);
            } else {
                log.info("Stored seed " + seedValue + " retrieved for " + name);
                result = new RandomSeed(classname, id, purpose, seedValue);
            }
            this.seedMap.put(name, result);
        } else {
            log.info("Seed from map for " + name);
        }
        return result;
    }

    public void restoreRandomSeed(RandomSeed seed) {
        String name = this.composeName(seed.getRequesterClass(), seed.getRequesterId(), seed.getPurpose());
        this.seedMap.put(name, seed);
    }

    private String composeName(String classname, long id, String purpose) {
        StringBuffer buf = new StringBuffer();
        buf.append(classname).append(";").append(id).append(";").append(purpose);
        return buf.toString();
    }

    public void recycle() {
        this.seedMap.clear();
        this.pendingSeedMap.clear();
    }

    int size() {
        return this.seedMap.size();
    }
}

