/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.interfaces.CustomerServiceAccessor;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;

public abstract class AbstractCustomer {
    protected static Logger log = LogManager.getLogger((String)AbstractCustomer.class.getName());
    protected String name = "dummy";
    protected HashMap<PowerType, List<CustomerInfo>> customerInfos;
    protected List<CustomerInfo> allCustomerInfos;
    protected CustomerServiceAccessor service;
    private long id = IdGenerator.createId();
    protected RandomSeed rs1;
    private TariffMarket tariffMarketService;

    public AbstractCustomer() {
        this.customerInfos = new HashMap();
        this.allCustomerInfos = new ArrayList<CustomerInfo>();
    }

    public AbstractCustomer(String name) {
        this();
        this.name = name;
    }

    public void setServiceAccessor(CustomerServiceAccessor csa) {
        this.service = csa;
    }

    public void initialize() {
        this.rs1 = this.service.getRandomSeedRepo().getRandomSeed(this.name, 0L, "TariffChooser");
    }

    public void handleInitialSubscription(List<TariffSubscription> subscriptions) {
    }

    public void saveBootstrapState() {
    }

    public void addCustomerInfo(CustomerInfo info) {
        if (this.customerInfos.get(info.getPowerType()) == null) {
            this.customerInfos.put(info.getPowerType(), new ArrayList());
        }
        this.customerInfos.get(info.getPowerType()).add(info);
        this.allCustomerInfos.add(info);
    }

    public CustomerInfo getCustomerInfo(PowerType pt) {
        return this.getCustomerInfoList(pt).get(0);
    }

    public List<CustomerInfo> getCustomerInfoList(PowerType pt) {
        return this.customerInfos.get(pt);
    }

    public List<CustomerInfo> getCustomerInfos() {
        return new ArrayList<CustomerInfo>(this.allCustomerInfos);
    }

    public List<TariffSubscription> getCurrentSubscriptions() {
        return this.service.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(this.allCustomerInfos.get(0));
    }

    public List<TariffSubscription> getCurrentSubscriptions(PowerType type) {
        return this.service.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(this.customerInfos.get(type).get(0));
    }

    public String toString() {
        return String.valueOf(Long.toString(this.getId())) + " " + this.getName();
    }

    public int getPopulation(CustomerInfo customer) {
        return customer.getPopulation();
    }

    public long getCustId() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract void step();

    public TariffEvaluator createTariffEvaluator(CustomerModelAccessor cma) {
        ServerConfiguration config = this.service.getServerConfiguration();
        TariffEvaluator te = new TariffEvaluator(cma, config);
        return te;
    }

    public abstract void evaluateTariffs(List<Tariff> var1);

    public Instant lastSunday() {
        Instant start = this.service.getTimeslotRepo().currentTimeslot().getStartInstant();
        return start.toDateTime(DateTimeZone.UTC).withDayOfWeek(1).withHourOfDay(0).toInstant();
    }

    protected Instant startOfDay() {
        Instant start = this.service.getTimeslotRepo().currentTimeslot().getStartInstant();
        return start.toDateTime(DateTimeZone.UTC).withHourOfDay(0).toInstant();
    }

    protected Instant nextStartOfDay() {
        Instant start = this.service.getTimeslotRepo().currentTimeslot().getStartInstant();
        return start.toDateTime(DateTimeZone.UTC).withHourOfDay(0).toInstant().plus(86400000L);
    }

    public void setTariffMarket(TariffMarket service) {
        this.tariffMarketService = service;
    }

    public void changeSubscription(Tariff tariff, Tariff newTariff, CustomerInfo customer) {
        TariffSubscription ts = this.service.getTariffSubscriptionRepo().getSubscription(customer, tariff);
        int populationCount = ts.getCustomersCommitted();
        this.unsubscribe(ts, populationCount);
        this.subscribe(newTariff, populationCount, customer);
    }

    void subscribe(Tariff tariff, int customerCount, CustomerInfo customer) {
        this.tariffMarketService.subscribeToTariff(tariff, customer, customerCount);
        log.info(String.valueOf(this.toString()) + " " + tariff.getPowerType().toString() + ": " + customerCount + " were subscribed to tariff " + tariff.getId());
    }

    void unsubscribe(TariffSubscription subscription, int customerCount) {
        subscription.unsubscribe(customerCount);
        log.info(String.valueOf(this.toString()) + " " + subscription.getTariff().getPowerType().toString() + ": " + customerCount + " were unsubscribed from tariff " + subscription.getTariff().getId());
    }
}

