/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.PluginConfig;
import org.powertac.common.RandomSeed;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BootstrapDataCollector;
import org.powertac.common.interfaces.BrokerMessageListener;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BrokerAccept;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.PauseRelease;
import org.powertac.common.msg.PauseRequest;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.PluginConfigRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.server.JmsManagementService;
import org.powertac.server.LogService;
import org.powertac.server.ServerMessageReceiver;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.SimulationClockControl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service
public class CompetitionControlService
implements ApplicationContextAware,
CompetitionControl,
BrokerMessageListener {
    private static Logger log = Logger.getLogger(CompetitionControlService.class);
    private ApplicationContext applicationContext = null;
    private Competition competition;
    private int timeslotPhaseCount = 4;
    private boolean running = false;
    private SimulationClockControl clock;
    @Autowired
    private TimeService timeService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private LogService logService;
    @Autowired
    private PluginConfigRepo pluginConfigRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private BootstrapDataCollector defaultBroker;
    @Autowired
    private XMLMessageConverter messageConverter;
    @Autowired
    private JmsManagementService jmsManagementService;
    @Autowired
    private ServerMessageReceiver serverMessageReceiver;
    @Autowired
    private ServerPropertiesService serverProps;
    private ArrayList<List<TimeslotPhaseProcessor>> phaseRegistrations;
    private int timeslotCount = 0;
    private int currentSlot = 0;
    private int currentSlotOffset = 0;
    private RandomSeed randomGen;
    private ArrayList<String> alwaysAuthorizedBrokers;
    private ArrayList<String> authorizedBrokerList;
    private int idPrefix = 0;
    private String serverQueueName = "serverInput";
    private boolean bootstrapMode = true;
    private List<Object> bootstrapDataset = null;
    private long bootstrapTimeslotMillis = 2000L;
    private int bootstrapDiscardedTimeslots = 24;
    private boolean simRunning = false;
    String pauseRequester;

    public void preGame() {
        log.info((Object)"preGame() - start");
        this.competition = Competition.newInstance((String)"defaultCompetition");
        String suffix = this.serverProps.getProperty("server.logfileSuffix", "x");
        this.logService.startLog(suffix);
        log.info((Object)"pre-game initialization");
        this.configureCompetition(this.competition);
        this.phaseRegistrations = null;
        this.idPrefix = 0;
        Map repos = this.applicationContext.getBeansOfType(DomainRepo.class);
        log.debug((Object)("found " + repos.size() + " repos"));
        for (DomainRepo repo : repos.values()) {
            repo.recycle();
        }
        Map initializers = this.applicationContext.getBeansOfType(InitializationService.class);
        log.debug((Object)("found " + initializers.size() + " initializers"));
        for (InitializationService init : initializers.values()) {
            init.setDefaults();
        }
        this.jmsManagementService.registerMessageListener(this.serverQueueName, this.serverMessageReceiver);
        this.brokerProxyService.registerSimListener((BrokerMessageListener)this);
    }

    private void configureCompetition(Competition competition2) {
        int minimumTimeslotCount = this.serverProps.getIntegerProperty("competition.minimumTimeslotCount", this.competition.getMinimumTimeslotCount());
        int expectedTimeslotCount = this.serverProps.getIntegerProperty("competition.expectedTimeslotCount", this.competition.getExpectedTimeslotCount());
        if (expectedTimeslotCount < minimumTimeslotCount) {
            log.warn((Object)("competition expectedTimeslotCount " + expectedTimeslotCount + " < minimumTimeslotCount " + minimumTimeslotCount));
            expectedTimeslotCount = minimumTimeslotCount;
        }
        int bootstrapTimeslotCount = this.serverProps.getIntegerProperty("competition.bootstrapTimeslotCount", this.competition.getBootstrapTimeslotCount());
        int timeslotsOpen = this.serverProps.getIntegerProperty("competition.timeslotsOpen", this.competition.getTimeslotsOpen());
        int deactivateTimeslotsAhead = this.serverProps.getIntegerProperty("competition.deactivateTimeslotsAhead", this.competition.getDeactivateTimeslotsAhead());
        int timeslotLength = this.serverProps.getIntegerProperty("competition.timeslotLength", this.competition.getTimeslotLength());
        int simulationTimeslotSeconds = timeslotLength * 60 / (int)this.competition.getSimulationRate();
        simulationTimeslotSeconds = this.serverProps.getIntegerProperty("competition.simulationTimeslotSeconds", simulationTimeslotSeconds);
        int simulationRate = timeslotLength * 60 / simulationTimeslotSeconds;
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        Instant start = null;
        try {
            start = fmt.parseDateTime(this.serverProps.getProperty("competition.baseTime")).toInstant();
        }
        catch (Exception e) {
            log.error((Object)("Exception reading base time: " + e.toString()));
        }
        if (start == null) {
            start = this.competition.getSimulationBaseTime();
        }
        this.competition.withMinimumTimeslotCount(minimumTimeslotCount).withExpectedTimeslotCount(expectedTimeslotCount).withSimulationBaseTime(start).withSimulationRate((long)simulationRate).withTimeslotLength(timeslotLength).withSimulationModulo((long)timeslotLength * 60000L).withTimeslotsOpen(timeslotsOpen).withDeactivateTimeslotsAhead(deactivateTimeslotsAhead).withBootstrapTimeslotCount(bootstrapTimeslotCount);
        int bootstrapTimeslotSeconds = this.serverProps.getIntegerProperty("competition.bootstrapTimeslotSeconds", (int)(this.bootstrapTimeslotMillis / 1000L));
        this.bootstrapTimeslotMillis = (long)bootstrapTimeslotSeconds * 1000L;
    }

    public boolean preGame(File bootFile) {
        log.info((Object)"preGame(File) - start");
        this.bootstrapMode = false;
        this.preGame();
        Competition bootstrapCompetition = null;
        ArrayList<PluginConfig> configList = new ArrayList<PluginConfig>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/config/bootstrap-offset/@value");
            NodeList nodes = (NodeList)exp.evaluate(new InputSource(new FileReader(bootFile)), XPathConstants.NODESET);
            String value = nodes.item(0).getNodeValue();
            this.bootstrapDiscardedTimeslots = Integer.parseInt(value);
            log.info((Object)("offset: " + this.bootstrapDiscardedTimeslots + " timeslots"));
            exp = xPath.compile("/powertac-bootstrap-data/config/competition");
            nodes = (NodeList)exp.evaluate(new InputSource(new FileReader(bootFile)), XPathConstants.NODESET);
            String xml = this.nodeToString(nodes.item(0));
            bootstrapCompetition = (Competition)this.messageConverter.fromXML(xml);
            exp = xPath.compile("/powertac-bootstrap-data/config/plugin-config");
            nodes = (NodeList)exp.evaluate(new InputSource(new FileReader(bootFile)), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                xml = this.nodeToString(node);
                PluginConfig pic = (PluginConfig)this.messageConverter.fromXML(xml);
                configList.add(pic);
            }
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("preGame: Error reading config file: " + xee.toString()));
            return false;
        }
        catch (IOException ioe) {
            log.error((Object)("preGame: Error opening file " + bootFile + ": " + ioe.toString()));
        }
        Competition.currentCompetition().update(bootstrapCompetition);
        for (PluginConfig next : configList) {
            PluginConfig match = this.pluginConfigRepo.findMatching(next);
            if (match == null) {
                log.error((Object)("no matching PluginConfig found for " + next.toString()));
                return false;
            }
            match.update(next);
        }
        this.currentSlotOffset = this.competition.getBootstrapTimeslotCount() + this.bootstrapDiscardedTimeslots;
        this.createInitialTimeslots(this.competition.getSimulationBaseTime(), this.currentSlotOffset + 1, 0);
        log.info((Object)("created " + this.timeslotRepo.count() + " timeslots"));
        return true;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error((Object)("nodeToString Transformer Exception " + te.toString()));
        }
        String result = sw.toString();
        return result;
    }

    public void init() {
        this.runOnce();
        this.preGame();
    }

    public void setAlwaysAuthorizedBrokers(List<String> brokerList) {
        this.alwaysAuthorizedBrokers = new ArrayList<String>(brokerList);
    }

    public void setAuthorizedBrokerList(ArrayList<String> brokerList) {
        this.authorizedBrokerList = new ArrayList<String>(this.alwaysAuthorizedBrokers);
        for (String broker : brokerList) {
            this.authorizedBrokerList.add(broker);
        }
    }

    public void setBootstrapDiscardedTimeslots(int count) {
        this.bootstrapDiscardedTimeslots = count;
    }

    public void runOnce() {
        if (this.simRunning) {
            log.warn((Object)"attempt to start sim on top of running sim");
            return;
        }
        this.simRunning = true;
        if (this.competition == null) {
            log.error((Object)"null competition instance");
        }
        if (!this.setup()) {
            this.simRunning = false;
            return;
        }
        this.runSimulation((long)this.competition.getTimeslotLength() * 60000L / this.competition.getSimulationRate());
        this.shutDown();
        this.simRunning = false;
        this.logService.stopLog();
    }

    public void runOnce(File datasetFile) {
        this.bootstrapMode = false;
        this.bootstrapDataset = new ArrayList<Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            InputSource source = new InputSource(new FileReader(datasetFile));
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/bootstrap/*");
            NodeList nodes = (NodeList)exp.evaluate(source, XPathConstants.NODESET);
            log.info((Object)("Found " + nodes.getLength() + " bootstrap nodes"));
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xml = this.nodeToString(nodes.item(i));
                Object msg = this.messageConverter.fromXML(xml);
                this.bootstrapDataset.add(msg);
            }
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("runOnce: Error reading config file: " + xee.toString()));
        }
        catch (IOException ioe) {
            log.error((Object)("runOnce: reset fault: " + ioe.toString()));
        }
        this.runOnce();
    }

    public void runOnce(Writer datasetWriter) {
        this.bootstrapMode = true;
        this.runOnce();
        this.saveBootstrapData(datasetWriter);
    }

    void saveBootstrapData(Writer datasetWriter) {
        BufferedWriter output = new BufferedWriter(datasetWriter);
        List data = this.defaultBroker.collectBootstrapData(this.competition.getBootstrapTimeslotCount());
        try {
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            output.newLine();
            output.write("<powertac-bootstrap-data>");
            output.newLine();
            output.write("<config>");
            output.newLine();
            output.write("<bootstrap-offset value=\"" + this.bootstrapDiscardedTimeslots + "\" />");
            output.newLine();
            output.write(this.messageConverter.toXML((Object)this.competition));
            output.newLine();
            for (PluginConfig pic : this.pluginConfigRepo.list()) {
                output.write(this.messageConverter.toXML((Object)pic));
                output.newLine();
            }
            output.write("</config>");
            output.newLine();
            output.write("<bootstrap>");
            output.newLine();
            for (Object item : data) {
                output.write(this.messageConverter.toXML(item));
                output.newLine();
            }
            output.write("</bootstrap>");
            output.newLine();
            output.write("</powertac-bootstrap-data>");
            output.newLine();
            output.close();
        }
        catch (IOException ioe) {
            log.error((Object)("Error writing bootstrap file: " + ioe.toString()));
        }
    }

    private boolean setup() {
        this.randomGen = this.randomSeedRepo.getRandomSeed("CompetitionControlService", this.competition.getId(), "game-setup");
        this.setTimeParameters();
        this.brokerProxyService.setDeferredBroadcast(true);
        if (!this.configurePlugins()) {
            log.error((Object)"failed to configure plugins");
            return false;
        }
        this.createInitialTimeslots(this.timeService.getCurrentTime(), this.competition.getDeactivateTimeslotsAhead(), this.competition.getTimeslotsOpen());
        for (CustomerInfo customer : this.customerRepo.list()) {
            this.competition.addCustomer(customer);
        }
        this.waitForBrokerLogin();
        for (String retailer : this.brokerRepo.findRetailBrokerNames()) {
            this.competition.addBroker(retailer);
        }
        this.brokerProxyService.setDeferredBroadcast(false);
        this.brokerProxyService.broadcastMessage((Object)this.competition);
        this.brokerProxyService.broadcastMessages(this.pluginConfigRepo.findAllPublic());
        if (!this.bootstrapMode) {
            this.brokerProxyService.broadcastMessages(this.bootstrapDataset);
        }
        this.brokerProxyService.broadcastDeferredMessages();
        this.timeslotCount = !this.bootstrapMode ? this.computeGameLength(this.competition.getMinimumTimeslotCount(), this.competition.getExpectedTimeslotCount()) : this.competition.getBootstrapTimeslotCount() + this.bootstrapDiscardedTimeslots;
        TimeslotUpdate msg = new TimeslotUpdate(this.timeService.getCurrentTime(), this.timeslotRepo.enabledTimeslots());
        this.brokerProxyService.broadcastMessage((Object)msg);
        return true;
    }

    private synchronized void waitForBrokerLogin() {
        if (this.authorizedBrokerList == null || this.authorizedBrokerList.size() == 0) {
            return;
        }
        if (log.isInfoEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("waiting for logins from");
            for (String name : this.authorizedBrokerList) {
                msg.append(" ").append(name);
            }
            log.info((Object)msg.toString());
        }
        try {
            while (this.authorizedBrokerList.size() > 0) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            this.authorizedBrokerList.clear();
        }
    }

    public synchronized boolean loginBroker(String username) {
        if (this.authorizedBrokerList == null || this.authorizedBrokerList.size() == 0 || !this.authorizedBrokerList.contains(username)) {
            log.info((Object)("Unauthorized attempt to log in " + username));
            return false;
        }
        log.info((Object)("Log in broker " + username));
        Broker broker = this.brokerRepo.findByUsername(username);
        if (broker == null) {
            broker = new Broker(username);
            this.brokerRepo.add(broker);
            this.brokerProxyService.sendMessage(broker, (Object)new BrokerAccept(++this.idPrefix));
        }
        broker.setEnabled(true);
        this.authorizedBrokerList.remove(username);
        if (this.authorizedBrokerList.size() == 0) {
            this.notifyAll();
        }
        return true;
    }

    private void setTimeParameters() {
        Instant base = this.competition.getSimulationBaseTime();
        long rate = this.competition.getSimulationRate();
        if (!this.bootstrapMode) {
            int slotCount = this.currentSlotOffset;
            log.info((Object)("first slot: " + slotCount));
            base = base.plus((long)slotCount * this.competition.getTimeslotDuration());
        } else {
            rate = this.competition.getTimeslotDuration() / this.bootstrapTimeslotMillis;
        }
        long rem = rate % (long)this.competition.getTimeslotLength();
        if (rem > 0L) {
            long mult = this.competition.getSimulationRate() / (long)this.competition.getTimeslotLength();
            log.warn((Object)("Simulation rate " + rate + " not a multiple of " + this.competition.getTimeslotLength() + "; adjust to " + (mult + 1L) * (long)this.competition.getTimeslotLength()));
            rate = (mult + 1L) * (long)this.competition.getTimeslotLength();
        }
        this.timeService.setClockParameters(base.getMillis(), rate, this.competition.getTimeslotDuration());
        this.timeService.setCurrentTime(base);
    }

    private int computeGameLength(int minLength, int expLength) {
        double roll = this.randomGen.nextDouble();
        double k = Math.log(1.0 - roll) / Math.log(1.0 - 1.0 / (double)(expLength - minLength + 1));
        int length = minLength + (int)Math.floor(k);
        log.info((Object)("game-length " + length + "(k=" + k + ", roll=" + roll + ")"));
        return length;
    }

    private boolean configurePlugins() {
        Map initializers = this.applicationContext.getBeansOfType(InitializationService.class);
        ArrayList<String> completedPlugins = new ArrayList<String>();
        ArrayList<InitializationService> deferredInitializers = new ArrayList<InitializationService>();
        for (InitializationService initializer : initializers.values()) {
            log.info((Object)("attempt to initialize " + initializer.toString()));
            String success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info((Object)("deferring " + initializer.toString()));
                deferredInitializers.add(initializer);
                continue;
            }
            if (success == "fail") {
                log.error((Object)("Failed to initialize plugin " + initializer.toString()));
                return false;
            }
            log.info((Object)("completed " + success));
            completedPlugins.add(success);
        }
        int tryCounter = deferredInitializers.size();
        ArrayList<InitializationService> remaining = deferredInitializers;
        while (remaining.size() > 0 && tryCounter > 0) {
            InitializationService initializer = (InitializationService)remaining.get(0);
            log.info((Object)("additional attempt to initialize " + initializer.toString()));
            if (remaining.size() > 1) {
                remaining.remove(0);
            } else {
                remaining.clear();
            }
            String success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info((Object)("deferring " + initializer.toString()));
                remaining.add(initializer);
                --tryCounter;
                continue;
            }
            log.info((Object)("completed " + success));
            completedPlugins.add(success);
        }
        for (InitializationService initializer : remaining) {
            log.error((Object)("Failed to initialize " + initializer.toString()));
        }
        return true;
    }

    private void createInitialTimeslots(Instant base, int initialSlots, int openSlots) {
        int i;
        long timeslotMillis = this.competition.getTimeslotDuration();
        for (i = 0; i < initialSlots - 1; ++i) {
            Timeslot ts = this.timeslotRepo.makeTimeslot(base.plus((long)i * timeslotMillis));
            ts.disable();
        }
        for (i = initialSlots - 1; i < initialSlots + openSlots - 1; ++i) {
            this.timeslotRepo.makeTimeslot(base.plus((long)i * timeslotMillis));
        }
    }

    private void runSimulation(long scheduleMillis) {
        SimRunner runner = new SimRunner(this);
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException ie) {
            log.warn((Object)"sim interrupted", (Throwable)ie);
        }
    }

    private void step() {
        Instant time = this.timeService.getCurrentTime();
        Date started = new Date();
        this.activateNextTimeslot();
        log.info((Object)("step at " + time.toString()));
        for (int index = 0; index < this.phaseRegistrations.size(); ++index) {
            log.info((Object)("activate phase " + (index + 1)));
            for (TimeslotPhaseProcessor fn : this.phaseRegistrations.get(index)) {
                fn.activate(time, index + 1);
            }
        }
        Date ended = new Date();
        log.info((Object)("Elapsed time: " + (ended.getTime() - started.getTime())));
        if (--this.timeslotCount <= 0) {
            log.info((Object)"Stopping simulation");
            this.stop();
        }
    }

    private void activateNextTimeslot() {
        long timeslotMillis = this.competition.getTimeslotDuration();
        Timeslot current = this.timeslotRepo.currentTimeslot();
        if (current == null) {
            log.error((Object)("current timeslot is null at " + this.timeService.getCurrentTime()));
            return;
        }
        if (current.getSerialNumber() != this.currentSlot + this.currentSlotOffset) {
            log.error((Object)("current timeslot serial is " + current.getSerialNumber() + ", should be " + (this.currentSlot + this.currentSlotOffset)));
        }
        int oldSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1;
        Timeslot oldTs = this.timeslotRepo.findBySerialNumber(oldSerial);
        oldTs.disable();
        log.info((Object)("Deactivated timeslot " + oldSerial + ", start " + oldTs.getStartInstant().toString()));
        int newSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1 + this.competition.getTimeslotsOpen();
        Timeslot newTs = this.timeslotRepo.findBySerialNumber(newSerial);
        if (newTs == null) {
            long start = current.getStartInstant().getMillis() + (long)(newSerial - current.getSerialNumber()) * timeslotMillis;
            newTs = this.timeslotRepo.makeTimeslot(new Instant(start));
        } else {
            newTs.enable();
        }
        log.info((Object)("Activated timeslot " + newSerial + ", start " + newTs.getStartInstant()));
        TimeslotUpdate msg = new TimeslotUpdate(this.timeService.getCurrentTime(), this.timeslotRepo.enabledTimeslots());
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void stop() {
        this.running = false;
    }

    private void shutDown() {
        this.running = false;
        SimEnd endMsg = new SimEnd();
        this.brokerProxyService.broadcastMessage((Object)endMsg);
    }

    public void registerTimeslotPhase(TimeslotPhaseProcessor thing, int phase) {
        if (phase <= 0 || phase > this.timeslotPhaseCount) {
            log.error((Object)("phase " + phase + " out of range (1.." + this.timeslotPhaseCount + ")"));
        } else {
            if (this.phaseRegistrations == null) {
                this.phaseRegistrations = new ArrayList();
                for (int index = 0; index < this.timeslotPhaseCount; ++index) {
                    this.phaseRegistrations.add(new ArrayList());
                }
            }
            this.phaseRegistrations.get(phase - 1).add(thing);
        }
    }

    public boolean isBootstrapMode() {
        return this.bootstrapMode;
    }

    public void pause() {
        log.info((Object)"pause");
        SimPause msg = new SimPause();
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void resume(long newStart) {
        log.info((Object)"resume");
        SimResume msg = new SimResume(new Instant(newStart));
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void receiveMessage(PauseRequest msg) {
        if (this.pauseRequester != null) {
            log.info((Object)"Pause request by ${msg.broker.username} rejected; already paused by ${pauseRequester}");
            return;
        }
        this.pauseRequester = msg.getBroker().getUsername();
        log.info((Object)"Pause request by ${msg.broker.username}");
        this.clock.requestPause();
    }

    public void receiveMessage(PauseRelease msg) {
        if (this.pauseRequester == null) {
            log.info((Object)"Release request by ${msg.broker.username}, but no pause currently requested");
            return;
        }
        if (this.pauseRequester != msg.getBroker().getUsername()) {
            log.info((Object)"Release request by ${msg.broker.username}, but pause request was by ${pauseRequester}");
            return;
        }
        log.info((Object)"Pause released by ${msg.broker.username}");
        this.clock.releasePause();
        this.pauseRequester = null;
    }

    public void receiveMessage(BrokerAuthentication msg) {
        log.info((Object)"receiveMessage(BrokerAuthentication) - start");
        Broker broker = msg.getBroker();
        if (broker != null) {
            this.loginBroker(broker.getUsername());
        }
        log.info((Object)"receiveMessage(BrokerAuthentication) - end");
    }

    public void setBootstrapTimeslotMillis(long length) {
        this.bootstrapTimeslotMillis = length;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void receiveMessage(Object msg) {
        if (msg instanceof PauseRelease) {
            this.receiveMessage((PauseRelease)msg);
        } else if (msg instanceof PauseRequest) {
            this.receiveMessage((PauseRequest)msg);
        } else if (msg instanceof BrokerAuthentication) {
            this.receiveMessage((BrokerAuthentication)msg);
        } else {
            log.error((Object)("receiveMessage - unexpected message:" + msg));
        }
    }

    class SimRunner
    extends Thread {
        CompetitionControlService parent;

        public SimRunner(CompetitionControlService instance) {
            this.parent = instance;
        }

        @Override
        public void run() {
            SimulationClockControl.initialize(this.parent, CompetitionControlService.this.timeService);
            CompetitionControlService.this.clock = SimulationClockControl.getInstance();
            long now = new Date().getTime();
            long start = now + 1000L;
            SimStart startMsg = new SimStart(new Instant(start));
            CompetitionControlService.this.brokerProxyService.broadcastMessage((Object)startMsg);
            CompetitionControlService.this.clock.setStart(start);
            CompetitionControlService.this.timeService.init();
            CompetitionControlService.this.running = true;
            CompetitionControlService.this.clock.scheduleTick();
            while (CompetitionControlService.this.running) {
                log.info((Object)("Wait for tick " + CompetitionControlService.this.currentSlot));
                CompetitionControlService.this.clock.waitForTick(CompetitionControlService.this.currentSlot);
                CompetitionControlService.this.step();
                CompetitionControlService.this.currentSlot += 1;
                CompetitionControlService.this.clock.complete();
            }
            log.info((Object)"Stop simulation");
            CompetitionControlService.this.clock.stop();
        }
    }
}

