/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.stereotype.Service;

@Service
public class JmsManagementService {
    private static Logger log = Logger.getLogger(JmsManagementService.class);
    @Resource(name="jmsFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private Executor taskExecutor;
    private Map<MessageListener, AbstractMessageListenerContainer> listenerContainerMap = new HashMap<MessageListener, AbstractMessageListenerContainer>();

    public void initializeServerQueue(String serverQueueName) {
        this.createQueue(serverQueueName);
    }

    public void initializeBrokersQueues(String[] queueNames) {
        for (String queueName : queueNames) {
            this.createQueue(queueName);
        }
    }

    public Queue createQueue(String queueName) {
        Queue queue = null;
        try {
            Connection connection = this.connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            queue = session.createQueue(queueName);
        }
        catch (JMSException e) {
            log.error((Object)("Failed to create queue " + queueName), (Throwable)e);
        }
        return queue;
    }

    public void registerMessageListener(String destinationName, MessageListener listener) {
        log.info((Object)("registerMessageListener(" + destinationName + ", " + listener + ")"));
        DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
        container.setConnectionFactory(this.connectionFactory);
        container.setDestinationName(destinationName);
        container.setMessageListener((Object)listener);
        container.setTaskExecutor(this.taskExecutor);
        container.afterPropertiesSet();
        container.start();
        this.listenerContainerMap.put(listener, (AbstractMessageListenerContainer)container);
    }
}

