/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.ServerProperties;
import org.powertac.server.CompetitionControlService;
import org.powertac.server.ServerPropertiesService;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PowerTacServer {
    private static Logger log = Logger.getLogger(PowerTacServer.class);
    private static CompetitionControlService cc = null;
    private static ServerPropertiesService serverProps = null;

    public static void main(String[] args) {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("powertac.xml");
        context.registerShutdownHook();
        cc = (CompetitionControlService)context.getBeansOfType(CompetitionControl.class).values().toArray()[0];
        serverProps = (ServerPropertiesService)context.getBeansOfType(ServerProperties.class).values().toArray()[0];
        if (args.length == 1) {
            try {
                String input;
                BufferedReader config = new BufferedReader(new FileReader(args[0]));
                while ((input = config.readLine()) != null) {
                    String[] tokens = input.split("\\s+");
                    if ("bootstrap".equals(tokens[0])) {
                        if (tokens.length == 2 || tokens.length > 3) {
                            System.out.println("Bad input " + input);
                            continue;
                        }
                        if (tokens.length == 3 && "--config".equals(tokens[1])) {
                            serverProps.setUserConfig(tokens[2]);
                        }
                        FileWriter bootWriter = new FileWriter(serverProps.getProperty("server.bootstrapDataFile", "bootstrapData.xml"));
                        cc.setAuthorizedBrokerList(new ArrayList<String>());
                        cc.preGame();
                        cc.runOnce(bootWriter);
                        continue;
                    }
                    if (!"sim".equals(tokens[0])) continue;
                    int brokerIndex = 1;
                    if (tokens.length < 2) {
                        System.out.println("Bad input: " + input);
                    } else if ("--config".equals(tokens[1])) {
                        if (tokens.length < 4) {
                            System.out.println("No brokers given for sim: " + input);
                        } else {
                            serverProps.setUserConfig(tokens[2]);
                        }
                        brokerIndex = 3;
                    }
                    log.info((Object)"In Simulation mode!!!");
                    File bootFile = new File(serverProps.getProperty("server.bootstrapDataFile", "bd-noname.xml"));
                    ArrayList<String> brokerList = new ArrayList<String>();
                    for (int i = brokerIndex; i < tokens.length; ++i) {
                        brokerList.add(tokens[i]);
                    }
                    if (brokerList.size() > 0) {
                        cc.setAuthorizedBrokerList(brokerList);
                        if (!cc.preGame(bootFile)) continue;
                        cc.runOnce(bootFile);
                        continue;
                    }
                    System.out.println("Cannot run sim without brokers");
                }
            }
            catch (FileNotFoundException fnf) {
                System.out.println("Cannot find file " + args[0]);
            }
            catch (IOException ioe) {
                System.out.println("Error reading file " + args[0]);
            }
        } else {
            if (args.length == 0) {
                System.out.println("Server BootStrap");
                cc.preGame();
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            System.out.println("Usage: powertac-server [filename]");
        }
        System.exit(0);
    }
}

