/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BrokerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerMessageReceiver
implements MessageListener {
    private static Logger log = Logger.getLogger(ServerMessageReceiver.class);
    @Autowired
    XMLMessageConverter converter;
    @Autowired
    BrokerProxy brokerProxy;

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            try {
                log.info((Object)"onMessage(Message) - receiving a message");
                this.onMessage(((TextMessage)message).getText());
            }
            catch (JMSException e) {
                log.error((Object)"failed to extract text from TextMessage", (Throwable)e);
            }
        }
    }

    private void onMessage(String xml) {
        log.info((Object)("onMessage(String) - received message:\n" + xml));
        Object message = this.converter.fromXML(xml);
        log.info((Object)("onMessage(String) - received message of type " + message.getClass().getSimpleName()));
        this.brokerProxy.routeMessage(message);
    }
}

