/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.powertac.common.interfaces.ServerProperties;
import org.springframework.stereotype.Service;

@Service
public class ServerPropertiesService
implements ServerProperties {
    private static Logger log = Logger.getLogger(ServerProperties.class);
    private Properties classpathProps = null;
    private Properties defaultFileProps = null;
    private Properties userFileProps = null;
    private boolean initialized = false;

    void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.classpathProps = new Properties();
        InputStream propStream = ClassLoader.getSystemResourceAsStream("server.properties");
        if (propStream != null) {
            try {
                this.classpathProps.load(propStream);
            }
            catch (IOException ioe) {
                log.error((Object)("Error loading server.properties: " + ioe.toString()));
            }
        } else {
            log.error((Object)"Cannot find server.properties on classpath");
        }
        this.defaultFileProps = new Properties(this.classpathProps);
        try {
            FileInputStream fileStream = new FileInputStream("config/server.properties");
            this.defaultFileProps.load(fileStream);
        }
        catch (FileNotFoundException fnf) {
            log.warn((Object)"Cannot find config/server.properties");
        }
        catch (IOException e) {
            log.error((Object)("Error loading file config/server.properties: " + e.toString()));
        }
        this.userFileProps = new Properties(this.defaultFileProps);
    }

    public void setUserConfig(String userConfigFile) {
        this.init();
        try {
            FileInputStream fileStream = new FileInputStream(userConfigFile);
            this.userFileProps.load(fileStream);
        }
        catch (FileNotFoundException fnf) {
            log.error((Object)("Cannot find server config file " + userConfigFile));
        }
        catch (IOException e) {
            log.error((Object)("Error loading file " + userConfigFile + ": " + e.toString()));
        }
    }

    public String getProperty(String name) {
        this.init();
        return this.userFileProps.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        this.init();
        return this.userFileProps.getProperty(name, defaultValue);
    }

    public Integer getIntegerProperty(String name, Integer defaultValue) {
        String value = this.getProperty(name);
        Integer number = null;
        if (value != null) {
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Cannot parse property " + name + "=" + value + " as Integer"));
            }
        }
        if (value == null || number == null) {
            log.warn((Object)("property " + name + " not given in config"));
            return defaultValue;
        }
        return number;
    }

    public Double getDoubleProperty(String name, Double defaultValue) {
        String value = this.getProperty(name);
        Double number = null;
        if (value != null) {
            try {
                number = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Cannot parse property " + name + "=" + value + " as Double"));
            }
        }
        if (value == null || number == null) {
            log.warn((Object)("property " + name + " not given in config"));
            return defaultValue;
        }
        return number;
    }
}

