/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BrokerMessageListener;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.VisualizerProxy;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.server.MessageListenerRegistrar;
import org.powertac.server.MessageRouter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

@Service
public class BrokerProxyService
implements BrokerProxy {
    private static Logger log = Logger.getLogger(BrokerProxyService.class);
    @Autowired
    private JmsTemplate template;
    @Autowired
    private XMLMessageConverter converter;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private MessageRouter router;
    @Autowired
    private MessageListenerRegistrar registrar;
    @Autowired
    private VisualizerProxy visualizerProxyService;
    boolean deferredBroadcast = false;
    ArrayList<Object> deferredMessages = new ArrayList();

    public void sendMessage(Broker broker, Object messageObject) {
        if (broker.isEnabled()) {
            this.visualizerProxyService.forwardMessage(messageObject);
        }
        this.localSendMessage(broker, messageObject);
    }

    private void localSendMessage(Broker broker, Object messageObject) {
        if (messageObject == null) {
            log.error((Object)"null message ignored");
            return;
        }
        if (!broker.isEnabled()) {
            log.warn((Object)("broker " + broker.getUsername() + " is disabled"));
            return;
        }
        if (broker.isLocal()) {
            broker.receiveMessage(messageObject);
        } else {
            final String text = this.converter.toXML(messageObject);
            log.debug((Object)("send " + messageObject.toString() + " to " + broker.getUsername()));
            log.debug((Object)("sending text: \n" + text));
            String queueName = broker.toQueueName();
            this.template.send(queueName, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    TextMessage message = session.createTextMessage(text);
                    return message;
                }
            });
        }
    }

    public void sendMessages(Broker broker, List<?> messageObjects) {
        for (Object message : messageObjects) {
            this.sendMessage(broker, message);
        }
    }

    public void broadcastMessage(Object messageObject) {
        if (this.deferredBroadcast) {
            this.deferredMessages.add(messageObject);
            return;
        }
        this.visualizerProxyService.forwardMessage(messageObject);
        Collection brokers = this.brokerRepo.list();
        for (Broker broker : brokers) {
            this.localSendMessage(broker, messageObject);
        }
    }

    public void broadcastMessages(List<?> messageObjects) {
        for (Object message : messageObjects) {
            this.broadcastMessage(message);
        }
    }

    public void routeMessage(Object message) {
        if (this.router.route(message)) {
            this.visualizerProxyService.forwardMessage(message);
        }
    }

    public void registerBrokerMarketListener(BrokerMessageListener listener) {
        this.registrar.registerBrokerMarketListener(listener);
    }

    public void registerBrokerTariffListener(BrokerMessageListener listener) {
        this.registrar.registerBrokerTariffListener(listener);
    }

    public void registerSimListener(BrokerMessageListener listener) {
        this.registrar.registerSimListener(listener);
    }

    public void setDeferredBroadcast(boolean b) {
        this.deferredBroadcast = b;
    }

    public void broadcastDeferredMessages() {
        this.deferredBroadcast = false;
        log.info((Object)("broadcasting " + this.deferredMessages.size() + " deferred messages"));
        this.broadcastMessages(this.deferredMessages);
        this.deferredMessages.clear();
    }
}

