/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.interfaces.BrokerMessageListener;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BrokerAccept;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.PauseRelease;
import org.powertac.common.msg.PauseRequest;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.PluginConfigRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.JmsManagementService;
import org.powertac.server.LogService;
import org.powertac.server.ServerMessageReceiver;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.SimulationClockControl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompetitionControlService
implements CompetitionControl,
BrokerMessageListener {
    private static Logger log = Logger.getLogger(CompetitionControlService.class);
    private Competition competition;
    private int timeslotPhaseCount = 4;
    private boolean running = false;
    private SimulationClockControl clock;
    @Autowired
    private TimeService timeService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private LogService logService;
    @Autowired
    private PluginConfigRepo pluginConfigRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private ServerPropertiesService configService;
    @Autowired
    private ServerMessageReceiver serverMessageReceiver;
    @Autowired
    private JmsManagementService jmsManagementService;
    private String serverQueueName = "serverInput";
    private ArrayList<List<TimeslotPhaseProcessor>> phaseRegistrations;
    private int timeslotCount = 0;
    private int currentSlot = 0;
    private int currentSlotOffset = 0;
    private RandomSeed randomGen;
    private ArrayList<String> alwaysAuthorizedBrokers;
    private ArrayList<String> authorizedBrokerList;
    private int idPrefix = 0;
    private boolean bootstrapMode = true;
    private List<Object> bootstrapDataset = null;
    private long bootstrapTimeslotMillis = 2000L;
    private boolean simRunning = false;
    String pauseRequester;

    public void init() {
        this.phaseRegistrations = null;
        this.idPrefix = 0;
        this.jmsManagementService.initializeServerQueue(this.serverQueueName);
        this.jmsManagementService.registerMessageListener(this.serverQueueName, this.serverMessageReceiver);
        String[] brokerArray = new String[this.authorizedBrokerList.size()];
        this.jmsManagementService.initializeBrokersQueues(this.authorizedBrokerList.toArray(brokerArray));
        this.brokerProxyService.registerSimListener((BrokerMessageListener)this);
    }

    public void setAlwaysAuthorizedBrokers(List<String> brokerList) {
        this.alwaysAuthorizedBrokers = new ArrayList<String>(brokerList);
    }

    public void setAuthorizedBrokerList(List<String> list) {
        this.authorizedBrokerList = new ArrayList<String>(this.alwaysAuthorizedBrokers);
        for (String broker : list) {
            this.authorizedBrokerList.add(broker);
        }
    }

    void setBootstrapDataset(List<Object> dataset) {
        this.bootstrapDataset = dataset;
    }

    public void runOnce(boolean bootstrapMode) {
        this.bootstrapMode = bootstrapMode;
        this.competition = Competition.currentCompetition();
        this.jmsManagementService.start();
        this.init();
        if (this.simRunning) {
            log.warn((Object)"attempt to start sim on top of running sim");
            return;
        }
        this.simRunning = true;
        if (this.competition == null) {
            log.error((Object)"null competition instance");
        }
        if (!this.setup()) {
            this.simRunning = false;
            return;
        }
        this.runSimulation((long)this.competition.getTimeslotLength() * 60000L / this.competition.getSimulationRate());
        this.shutDown();
        this.simRunning = false;
        this.clock.waitUntilStop();
        this.jmsManagementService.stop();
        this.logService.stopLog();
    }

    private boolean setup() {
        this.randomGen = this.randomSeedRepo.getRandomSeed("CompetitionControlService", this.competition.getId(), "game-setup");
        if (!this.bootstrapMode) {
            this.currentSlotOffset = this.competition.getBootstrapTimeslotCount() + this.competition.getBootstrapDiscardedTimeslots();
            this.createInitialTimeslots(this.competition.getSimulationBaseTime(), this.currentSlotOffset + 1, 0);
            log.info((Object)("created " + this.timeslotRepo.count() + " bootstrap timeslots"));
        }
        this.setTimeParameters();
        this.brokerProxyService.setDeferredBroadcast(true);
        if (!this.configurePlugins()) {
            log.error((Object)"failed to configure plugins");
            return false;
        }
        this.createInitialTimeslots(this.timeService.getCurrentTime(), this.competition.getDeactivateTimeslotsAhead(), this.competition.getTimeslotsOpen());
        for (CustomerInfo customer : this.customerRepo.list()) {
            this.competition.addCustomer(customer);
        }
        this.waitForBrokerLogin();
        for (String retailer : this.brokerRepo.findRetailBrokerNames()) {
            this.competition.addBroker(retailer);
        }
        this.brokerProxyService.setDeferredBroadcast(false);
        this.brokerProxyService.broadcastMessage((Object)this.competition);
        this.brokerProxyService.broadcastMessage((Object)this.configService.getPublishedConfiguration());
        if (!this.bootstrapMode) {
            this.brokerProxyService.broadcastMessages(this.bootstrapDataset);
        }
        this.brokerProxyService.broadcastDeferredMessages();
        this.timeslotCount = this.competition.getBootstrapTimeslotCount() + this.competition.getBootstrapDiscardedTimeslots();
        if (!this.bootstrapMode) {
            this.timeslotCount += this.computeGameLength(this.competition.getMinimumTimeslotCount(), this.competition.getExpectedTimeslotCount());
        }
        TimeslotUpdate msg = new TimeslotUpdate(this.timeService.getCurrentTime(), this.timeslotRepo.enabledTimeslots());
        this.brokerProxyService.broadcastMessage((Object)msg);
        return true;
    }

    private synchronized void waitForBrokerLogin() {
        if (this.authorizedBrokerList == null || this.authorizedBrokerList.size() == 0) {
            return;
        }
        if (log.isInfoEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("waiting for logins from");
            for (String name : this.authorizedBrokerList) {
                msg.append(" ").append(name);
            }
            log.info((Object)msg.toString());
        }
        try {
            while (this.authorizedBrokerList.size() > 0) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            this.authorizedBrokerList.clear();
        }
    }

    public synchronized boolean loginBroker(String username) {
        if (this.authorizedBrokerList == null || this.authorizedBrokerList.size() == 0 || !this.authorizedBrokerList.contains(username)) {
            log.info((Object)("Unauthorized attempt to log in " + username));
            return false;
        }
        log.info((Object)("Log in broker " + username));
        Broker broker = this.brokerRepo.findByUsername(username);
        if (broker == null) {
            broker = new Broker(username);
            this.brokerRepo.add(broker);
        }
        broker.setEnabled(true);
        this.brokerProxyService.sendMessage(broker, (Object)new BrokerAccept(++this.idPrefix));
        this.authorizedBrokerList.remove(username);
        if (this.authorizedBrokerList.size() == 0) {
            this.notifyAll();
        }
        return true;
    }

    private void setTimeParameters() {
        Instant base = this.competition.getSimulationBaseTime();
        long rate = this.competition.getSimulationRate();
        if (!this.bootstrapMode) {
            int slotCount = this.currentSlotOffset;
            log.info((Object)("first slot: " + slotCount));
            base = base.plus((long)slotCount * this.competition.getTimeslotDuration());
        } else {
            rate = this.competition.getTimeslotDuration() / this.bootstrapTimeslotMillis;
        }
        long rem = rate % (long)this.competition.getTimeslotLength();
        if (rem > 0L) {
            long mult = this.competition.getSimulationRate() / (long)this.competition.getTimeslotLength();
            log.warn((Object)("Simulation rate " + rate + " not a multiple of " + this.competition.getTimeslotLength() + "; adjust to " + (mult + 1L) * (long)this.competition.getTimeslotLength()));
            rate = (mult + 1L) * (long)this.competition.getTimeslotLength();
        }
        this.timeService.setClockParameters(base.getMillis(), rate, this.competition.getTimeslotDuration());
        this.timeService.setCurrentTime(base);
    }

    private int computeGameLength(int minLength, int expLength) {
        double roll = this.randomGen.nextDouble();
        double k = Math.log(1.0 - roll) / Math.log(1.0 - 1.0 / (double)(expLength - minLength + 1));
        int length = minLength + (int)Math.floor(k);
        log.info((Object)("game-length " + length + "(k=" + k + ", roll=" + roll + ")"));
        return length;
    }

    private boolean configurePlugins() {
        List initializers = SpringApplicationContext.listBeansOfType(InitializationService.class);
        ArrayList<String> completedPlugins = new ArrayList<String>();
        ArrayList<InitializationService> deferredInitializers = new ArrayList<InitializationService>();
        for (InitializationService initializer : initializers) {
            log.info((Object)("attempt to initialize " + initializer.toString()));
            String success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info((Object)("deferring " + initializer.toString()));
                deferredInitializers.add(initializer);
                continue;
            }
            if (success == "fail") {
                log.error((Object)("Failed to initialize plugin " + initializer.toString()));
                return false;
            }
            log.info((Object)("completed " + success));
            completedPlugins.add(success);
        }
        int tryCounter = deferredInitializers.size();
        ArrayList<InitializationService> remaining = deferredInitializers;
        while (remaining.size() > 0 && tryCounter > 0) {
            InitializationService initializer = (InitializationService)remaining.get(0);
            log.info((Object)("additional attempt to initialize " + initializer.toString()));
            if (remaining.size() > 1) {
                remaining.remove(0);
            } else {
                remaining.clear();
            }
            String success = initializer.initialize(this.competition, completedPlugins);
            if (success == null) {
                log.info((Object)("deferring " + initializer.toString()));
                remaining.add(initializer);
                --tryCounter;
                continue;
            }
            log.info((Object)("completed " + success));
            completedPlugins.add(success);
        }
        for (InitializationService initializer : remaining) {
            log.error((Object)("Failed to initialize " + initializer.toString()));
        }
        return true;
    }

    private void createInitialTimeslots(Instant base, int initialSlots, int openSlots) {
        int i;
        long timeslotMillis = this.competition.getTimeslotDuration();
        for (i = 0; i < initialSlots - 1; ++i) {
            Timeslot ts = this.timeslotRepo.makeTimeslot(base.plus((long)i * timeslotMillis));
            ts.disable();
        }
        for (i = initialSlots - 1; i < initialSlots + openSlots - 1; ++i) {
            this.timeslotRepo.makeTimeslot(base.plus((long)i * timeslotMillis));
        }
    }

    private void runSimulation(long scheduleMillis) {
        SimRunner runner = new SimRunner(this);
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException ie) {
            log.warn((Object)"sim interrupted", (Throwable)ie);
        }
    }

    private void step() {
        Instant time = this.timeService.getCurrentTime();
        Date started = new Date();
        this.activateNextTimeslot();
        log.info((Object)("step at " + time.toString()));
        for (int index = 0; index < this.phaseRegistrations.size(); ++index) {
            log.info((Object)("activate phase " + (index + 1)));
            for (TimeslotPhaseProcessor fn : this.phaseRegistrations.get(index)) {
                fn.activate(time, index + 1);
            }
        }
        Date ended = new Date();
        log.info((Object)("Elapsed time: " + (ended.getTime() - started.getTime())));
        if (--this.timeslotCount <= 0) {
            log.info((Object)"Stopping simulation");
            this.stop();
        }
    }

    private void activateNextTimeslot() {
        long timeslotMillis = this.competition.getTimeslotDuration();
        Timeslot current = this.timeslotRepo.currentTimeslot();
        if (current == null) {
            log.error((Object)("current timeslot is null at " + this.timeService.getCurrentTime()));
            return;
        }
        if (current.getSerialNumber() != this.currentSlot + this.currentSlotOffset) {
            log.error((Object)("current timeslot serial is " + current.getSerialNumber() + ", should be " + (this.currentSlot + this.currentSlotOffset)));
        }
        int oldSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1;
        Timeslot oldTs = this.timeslotRepo.findBySerialNumber(oldSerial);
        oldTs.disable();
        log.info((Object)("Deactivated timeslot " + oldSerial + ", start " + oldTs.getStartInstant().toString()));
        int newSerial = current.getSerialNumber() + this.competition.getDeactivateTimeslotsAhead() - 1 + this.competition.getTimeslotsOpen();
        Timeslot newTs = this.timeslotRepo.findBySerialNumber(newSerial);
        if (newTs == null) {
            long start = current.getStartInstant().getMillis() + (long)(newSerial - current.getSerialNumber()) * timeslotMillis;
            newTs = this.timeslotRepo.makeTimeslot(new Instant(start));
        } else {
            newTs.enable();
        }
        log.info((Object)("Activated timeslot " + newSerial + ", start " + newTs.getStartInstant()));
        TimeslotUpdate msg = new TimeslotUpdate(this.timeService.getCurrentTime(), this.timeslotRepo.enabledTimeslots());
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void stop() {
        this.running = false;
    }

    private void shutDown() {
        this.running = false;
        SimEnd endMsg = new SimEnd();
        this.brokerProxyService.broadcastMessage((Object)endMsg);
    }

    public void registerTimeslotPhase(TimeslotPhaseProcessor thing, int phase) {
        if (phase <= 0 || phase > this.timeslotPhaseCount) {
            log.error((Object)("phase " + phase + " out of range (1.." + this.timeslotPhaseCount + ")"));
        } else {
            if (this.phaseRegistrations == null) {
                this.phaseRegistrations = new ArrayList();
                for (int index = 0; index < this.timeslotPhaseCount; ++index) {
                    this.phaseRegistrations.add(new ArrayList());
                }
            }
            this.phaseRegistrations.get(phase - 1).add(thing);
        }
    }

    public boolean isBootstrapMode() {
        return this.bootstrapMode;
    }

    public void pause() {
        log.info((Object)"pause");
        SimPause msg = new SimPause();
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void resume(long newStart) {
        log.info((Object)"resume");
        SimResume msg = new SimResume(new Instant(newStart));
        this.brokerProxyService.broadcastMessage((Object)msg);
    }

    public void receiveMessage(PauseRequest msg) {
        if (this.pauseRequester != null) {
            log.info((Object)("Pause request by " + msg.getBroker().getUsername() + " rejected; already paused by " + this.pauseRequester));
            return;
        }
        this.pauseRequester = msg.getBroker().getUsername();
        log.info((Object)("Pause request by " + msg.getBroker().getUsername()));
        this.clock.requestPause();
    }

    public void receiveMessage(PauseRelease msg) {
        if (this.pauseRequester == null) {
            log.info((Object)("Release request by " + msg.getBroker().getUsername() + ", but no pause currently requested"));
            return;
        }
        if (this.pauseRequester != msg.getBroker().getUsername()) {
            log.info((Object)("Release request by " + msg.getBroker().getUsername() + ", but pause request was by " + this.pauseRequester));
            return;
        }
        log.info((Object)("Pause released by " + msg.getBroker().getUsername()));
        this.clock.releasePause();
        this.pauseRequester = null;
    }

    public void receiveMessage(BrokerAuthentication msg) {
        log.info((Object)"receiveMessage(BrokerAuthentication) - start");
        String username = msg.getUsername();
        this.loginBroker(username);
    }

    public void setBootstrapTimeslotMillis(long length) {
        this.bootstrapTimeslotMillis = length;
    }

    long getBootstrapTimeslotMillis() {
        return this.bootstrapTimeslotMillis;
    }

    public void receiveMessage(Object msg) {
        if (msg instanceof PauseRelease) {
            this.receiveMessage((PauseRelease)msg);
        } else if (msg instanceof PauseRequest) {
            this.receiveMessage((PauseRequest)msg);
        } else if (msg instanceof BrokerAuthentication) {
            this.receiveMessage((BrokerAuthentication)msg);
        } else {
            log.error((Object)("receiveMessage - unexpected message:" + msg));
        }
    }

    class SimRunner
    extends Thread {
        CompetitionControlService parent;

        public SimRunner(CompetitionControlService instance) {
            this.parent = instance;
        }

        @Override
        public void run() {
            SimulationClockControl.initialize(this.parent, CompetitionControlService.this.timeService);
            CompetitionControlService.this.clock = SimulationClockControl.getInstance();
            long now = new Date().getTime();
            long start = now + 1000L;
            SimStart startMsg = new SimStart(new Instant(start));
            CompetitionControlService.this.brokerProxyService.broadcastMessage((Object)startMsg);
            CompetitionControlService.this.clock.setStart(start);
            CompetitionControlService.this.timeService.init();
            CompetitionControlService.this.running = true;
            CompetitionControlService.this.clock.scheduleTick();
            while (CompetitionControlService.this.running) {
                log.info((Object)("Wait for tick " + CompetitionControlService.this.currentSlot));
                CompetitionControlService.this.clock.waitForTick(CompetitionControlService.this.currentSlot);
                CompetitionControlService.this.step();
                CompetitionControlService.this.currentSlot += 1;
                CompetitionControlService.this.clock.complete();
            }
            log.info((Object)"Stop simulation");
            CompetitionControlService.this.clock.stop();
        }
    }
}

