/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.PluginConfig;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BootstrapDataCollector;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.PluginConfigRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.CompetitionControlService;
import org.powertac.server.LogService;
import org.powertac.server.ServerPropertiesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service
public class CompetitionSetupService
implements CompetitionSetup {
    private static Logger log = Logger.getLogger(CompetitionSetupService.class);
    @Autowired
    private CompetitionControlService cc;
    @Autowired
    private BootstrapDataCollector defaultBroker;
    @Autowired
    private PluginConfigRepo pluginConfigRepo;
    @Autowired
    private ServerPropertiesService serverProps;
    @Autowired
    private XMLMessageConverter messageConverter;
    @Autowired
    private LogService logService;
    private Competition competition;

    void processCmdLine(String[] args) {
        if (args.length > 1) {
            this.processCli(args);
        } else if (args.length == 1) {
            this.processScript(args);
        } else {
            System.out.println("Server BootStrap");
            this.preGame();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private void processCli(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec bootOutput = parser.accepts("boot").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec controllerUrl = parser.accepts("control").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec serverConfigUrl = parser.accepts("server-config").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec logSuffixOption = parser.accepts("log-suffix").withRequiredArg();
        parser.accepts("sim");
        ArgumentAcceptingOptionSpec bootData = parser.accepts("boot-data").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec jmsUrl = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec brokerList = parser.accepts("brokers").withRequiredArg().withValuesSeparatedBy(',');
        OptionSet options = parser.parse(args);
        try {
            String jmsBrokerUrl;
            String logSuffix = (String)options.valueOf((OptionSpec)logSuffixOption);
            URL controller = (URL)options.valueOf((OptionSpec)controllerUrl);
            URL serverConfig = (URL)options.valueOf((OptionSpec)serverConfigUrl);
            if (serverConfig == null && controller != null) {
                serverConfig = new URL(controller, "server-config");
            }
            if (serverConfig != null) {
                this.serverProps.setUserConfig(serverConfig);
            }
            if ((jmsBrokerUrl = (String)options.valueOf((OptionSpec)jmsUrl)) != null) {
                this.serverProps.setProperty("server.jmsManagementService.jmsBrokerUrl", jmsBrokerUrl);
            }
            if (options.has((OptionSpec)bootOutput)) {
                this.setLogSuffix(logSuffix, controller, "boot");
                this.bootSession((File)options.valueOf((OptionSpec)bootOutput));
            } else if (options.has("sim")) {
                this.setLogSuffix(logSuffix, controller, "sim");
                URL bootDataUrl = (URL)options.valueOf((OptionSpec)bootData);
                if (bootDataUrl == null && controller != null) {
                    bootDataUrl = new URL(controller, "bootstrap-data");
                }
                if (bootDataUrl != null) {
                    this.simSession(options.valuesOf((OptionSpec)brokerList), bootDataUrl);
                } else {
                    System.err.println("Cannot run sim session without boot dataset");
                    System.exit(1);
                }
            } else {
                System.err.println("Must provide either --boot or --sim to run server");
                System.exit(1);
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
        catch (MalformedURLException e) {
            System.err.println("Cannot parse command line: " + e.toString());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("I/O Error: " + e.toString());
            System.exit(1);
        }
    }

    private void setLogSuffix(String logSuffix, URL controlUrl, String defaultSuffix) throws IOException {
        if (logSuffix == null && controlUrl != null) {
            URL suffixUrl = new URL(controlUrl, "log-suffix");
            log.info((Object)("retrieving logSuffix from " + suffixUrl.toExternalForm()));
            InputStream stream = suffixUrl.openStream();
            byte[] buffer = new byte[64];
            int len = stream.read(buffer);
            if (len > 0) {
                logSuffix = new String(buffer, 0, len);
                log.info((Object)("log suffix " + logSuffix + " retrieved"));
            }
        }
        if (logSuffix == null) {
            logSuffix = defaultSuffix;
        }
        this.serverProps.setProperty("server.logfileSuffix", logSuffix);
        String realSuffix = this.serverProps.getProperty("server.logfileSuffix");
    }

    private void processScript(String[] args) {
        System.out.println("old-style scriptfile interface");
        try {
            String input;
            BufferedReader config = new BufferedReader(new FileReader(args[0]));
            while ((input = config.readLine()) != null) {
                String[] tokens = input.split("\\s+");
                if ("bootstrap".equals(tokens[0])) {
                    if (tokens.length == 2 || tokens.length > 3) {
                        System.out.println("Bad input " + input);
                        continue;
                    }
                    if (tokens.length == 3 && "--config".equals(tokens[1])) {
                        this.serverProps.setUserConfig(new URL("file:" + tokens[2]));
                    }
                    String bootstrapFilename = this.serverProps.getProperty("server.bootstrapDataFile", "/bd-noname.xml");
                    this.bootSession(new File(bootstrapFilename));
                    continue;
                }
                if (!"sim".equals(tokens[0])) continue;
                int brokerIndex = 1;
                if (tokens.length > 2 && "--config".equals(tokens[1])) {
                    this.serverProps.setUserConfig(new URL("file:" + tokens[2]));
                    brokerIndex = 3;
                }
                log.info((Object)"In Simulation mode!!!");
                String bootstrapFilename = this.serverProps.getProperty("server.bootstrapDataFile", "bd-noname.xml");
                File bootFile = new File(bootstrapFilename);
                if (!bootFile.canRead()) {
                    System.out.println("Cannot read bootstrap data file " + bootstrapFilename);
                    continue;
                }
                ArrayList<String> brokerList = new ArrayList<String>();
                for (int i = brokerIndex; i < tokens.length; ++i) {
                    brokerList.add(tokens[i]);
                }
                URL bootDataset = new URL("file:" + bootFile);
                this.simSession(brokerList, bootDataset);
            }
        }
        catch (FileNotFoundException fnf) {
            System.out.println("Cannot find file " + args[0]);
        }
        catch (IOException ioe) {
            System.out.println("Error reading file " + args[0]);
        }
    }

    private void bootSession(File bootstrapFile) throws IOException {
        if (!bootstrapFile.getAbsoluteFile().getParentFile().canWrite()) {
            System.out.println("Cannot write to bootstrap data file " + bootstrapFile);
        } else {
            FileWriter bootWriter = new FileWriter(bootstrapFile);
            this.cc.setAuthorizedBrokerList(new ArrayList<String>());
            this.preGame();
            this.cc.runOnce(true);
            this.saveBootstrapData(bootWriter);
        }
    }

    private void simSession(List<String> list, URL bootDataset) {
        this.cc.setAuthorizedBrokerList(list);
        if (this.preGame(bootDataset)) {
            this.cc.setBootstrapDataset(this.processBootDataset(bootDataset));
            this.cc.runOnce(false);
        }
    }

    public void preGame() {
        String suffix = this.serverProps.getProperty("server.logfileSuffix", "x");
        this.logService.startLog(suffix);
        log.info((Object)"preGame() - start");
        this.competition = Competition.newInstance((String)"defaultCompetition");
        log.info((Object)"pre-game initialization");
        this.configureCompetition(this.competition);
        List repos = SpringApplicationContext.listBeansOfType(DomainRepo.class);
        log.debug((Object)("found " + repos.size() + " repos"));
        for (DomainRepo repo : repos) {
            repo.recycle();
        }
        List initializers = SpringApplicationContext.listBeansOfType(InitializationService.class);
        log.debug((Object)("found " + initializers.size() + " initializers"));
        for (InitializationService init : initializers) {
            init.setDefaults();
        }
    }

    private void configureCompetition(Competition competition) {
        this.serverProps.configureMe(competition);
        int bootstrapTimeslotSeconds = this.serverProps.getIntegerProperty("server.bootstrapTimeslotSeconds", (int)(this.cc.getBootstrapTimeslotMillis() / 1000L));
        this.cc.setBootstrapTimeslotMillis((long)bootstrapTimeslotSeconds * 1000L);
    }

    public boolean preGame(URL bootFile) {
        log.info((Object)"preGame(File) - start");
        this.preGame();
        Competition bootstrapCompetition = null;
        ArrayList<PluginConfig> configList = new ArrayList<PluginConfig>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/config/competition");
            NodeList nodes = (NodeList)exp.evaluate(new InputSource(bootFile.openStream()), XPathConstants.NODESET);
            String xml = this.nodeToString(nodes.item(0));
            bootstrapCompetition = (Competition)this.messageConverter.fromXML(xml);
            exp = xPath.compile("/powertac-bootstrap-data/config/plugin-config");
            nodes = (NodeList)exp.evaluate(new InputSource(bootFile.openStream()), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                xml = this.nodeToString(node);
                PluginConfig pic = (PluginConfig)this.messageConverter.fromXML(xml);
                configList.add(pic);
            }
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("preGame: Error reading boot dataset: " + xee.toString()));
            return false;
        }
        catch (IOException ioe) {
            log.error((Object)("preGame: Error opening file " + bootFile + ": " + ioe.toString()));
        }
        Competition.currentCompetition().update(bootstrapCompetition);
        for (PluginConfig next : configList) {
            PluginConfig match = this.pluginConfigRepo.findMatching(next);
            if (match == null) {
                log.error((Object)("no matching PluginConfig found for " + next.toString()));
                return false;
            }
            match.update(next);
        }
        return true;
    }

    void saveBootstrapData(Writer datasetWriter) {
        BufferedWriter output = new BufferedWriter(datasetWriter);
        List data = this.defaultBroker.collectBootstrapData(this.competition.getBootstrapTimeslotCount());
        try {
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            output.newLine();
            output.write("<powertac-bootstrap-data>");
            output.newLine();
            output.write("<config>");
            output.newLine();
            output.write(this.messageConverter.toXML((Object)this.competition));
            output.newLine();
            for (PluginConfig pic : this.pluginConfigRepo.list()) {
                output.write(this.messageConverter.toXML((Object)pic));
                output.newLine();
            }
            output.write("</config>");
            output.newLine();
            output.write("<bootstrap>");
            output.newLine();
            for (Object item : data) {
                output.write(this.messageConverter.toXML(item));
                output.newLine();
            }
            output.write("</bootstrap>");
            output.newLine();
            output.write("</powertac-bootstrap-data>");
            output.newLine();
            output.close();
        }
        catch (IOException ioe) {
            log.error((Object)("Error writing bootstrap file: " + ioe.toString()));
        }
    }

    private ArrayList<Object> processBootDataset(URL bootDataset) {
        ArrayList<Object> result = new ArrayList<Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            InputSource source = new InputSource(bootDataset.openStream());
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/bootstrap/*");
            NodeList nodes = (NodeList)exp.evaluate(source, XPathConstants.NODESET);
            log.info((Object)("Found " + nodes.getLength() + " bootstrap nodes"));
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xml = this.nodeToString(nodes.item(i));
                Object msg = this.messageConverter.fromXML(xml);
                result.add(msg);
            }
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("runOnce: Error reading config file: " + xee.toString()));
        }
        catch (IOException ioe) {
            log.error((Object)("runOnce: reset fault: " + ioe.toString()));
        }
        return result;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error((Object)("nodeToString Transformer Exception " + te.toString()));
        }
        String result = sw.toString();
        return result;
    }
}

