/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    private String filenamePrefix = "powertac";

    public LogService() {
    }

    public LogService(String config) {
        PropertyConfigurator.configure((String)config);
    }

    public void setPrefix(String prefix) {
        this.filenamePrefix = prefix;
    }

    public Logger getStateLogger() {
        return Logger.getLogger((String)"State");
    }

    public void startLog(String id) {
        Logger root = Logger.getRootLogger();
        Logger state = this.getStateLogger();
        root.removeAllAppenders();
        state.removeAllAppenders();
        try {
            PatternLayout logLayout = new PatternLayout("%r %-5p %c{2}: %m%n");
            FileAppender logFile = new FileAppender((Layout)logLayout, "log/" + this.filenamePrefix + "-" + id + ".trace", false);
            root.addAppender((Appender)logFile);
            PatternLayout stateLayout = new PatternLayout("%r:%m%n");
            FileAppender stateFile = new FileAppender((Layout)stateLayout, "log/" + this.filenamePrefix + "-" + id + ".state", false);
            state.addAppender((Appender)stateFile);
        }
        catch (IOException ioe) {
            System.out.println("Can't open log file");
            System.exit(0);
        }
    }

    public void stopLog() {
        this.stopLogger(Logger.getRootLogger());
        this.stopLogger(Logger.getLogger((String)"State"));
    }

    private void stopLogger(Logger logger) {
        Enumeration apps = logger.getAllAppenders();
        while (apps.hasMoreElements()) {
            ((Appender)apps.nextElement()).close();
        }
    }
}

