/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.HourlyCharge;
import org.powertac.common.Rate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.interfaces.BrokerMessageListener;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.PauseRelease;
import org.powertac.common.msg.PauseRequest;
import org.powertac.common.msg.TariffExpire;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.msg.VariableRateUpdate;
import org.powertac.server.MessageListenerRegistrar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageRouter {
    private static Logger log = Logger.getLogger(MessageRouter.class);
    @Autowired
    private MessageListenerRegistrar registrar;
    Set<?> tariffMessageTypes = new HashSet<Class>(Arrays.asList(TariffSpecification.class, Rate.class, HourlyCharge.class, TariffUpdate.class, TariffExpire.class, TariffRevoke.class, VariableRateUpdate.class));
    Set<?> simMessageTypes = new HashSet<Class>(Arrays.asList(PauseRequest.class, PauseRelease.class, BrokerAuthentication.class));

    public boolean route(Object message) {
        boolean routed = false;
        boolean byPassed = message instanceof BrokerAuthentication;
        String username = "unknown";
        Broker broker = null;
        if (!byPassed) {
            try {
                broker = (Broker)PropertyUtils.getSimpleProperty((Object)message, (String)"broker");
                username = broker.getUsername();
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Failed to extract broker", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Failed to extract broker", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"Failed to extract broker", (Throwable)e);
            }
        }
        if (byPassed || broker != null && broker.isEnabled()) {
            log.debug((Object)("route(Object) - routing " + message.getClass().getSimpleName() + " from " + username));
            routed = true;
            if (this.tariffMessageTypes.contains(message.getClass())) {
                for (BrokerMessageListener tariffMessageListener : this.registrar.getTariffRegistrations()) {
                    tariffMessageListener.receiveMessage(message);
                }
            } else if (this.simMessageTypes.contains(message.getClass())) {
                for (BrokerMessageListener simMessageListener : this.registrar.getSimRegistrations()) {
                    simMessageListener.receiveMessage(message);
                }
            } else {
                for (BrokerMessageListener marketMessageListener : this.registrar.getMarketRegistrations()) {
                    marketMessageListener.receiveMessage(message);
                }
            }
        }
        log.debug((Object)("route(Object) - routed:" + routed));
        return routed;
    }
}

