/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import org.powertac.common.TimeService;
import org.powertac.server.CompetitionControlService;
import org.springframework.beans.factory.annotation.Autowired;

public class SimulationClockControl {
    private static Logger log = Logger.getLogger(SimulationClockControl.class);
    private static final long postPauseDelay = 500L;
    private static final long watchdogSlack = 200L;
    @Autowired
    private TimeService timeService;
    @Autowired
    private CompetitionControlService competitionControl;
    private long base;
    private long start;
    private long rate;
    private long modulo;
    private Status state = Status.CLEAR;
    private int nextTick = -1;
    private boolean pauseRequested = false;
    private Timer theTimer;
    private WatchdogAction currentWatchdog;
    private Set<Semaphore> waitUntilStopSemaphores;
    private static SimulationClockControl instance;

    public static void initialize(CompetitionControlService competitionControl, TimeService timeService) {
        instance = new SimulationClockControl(competitionControl, timeService);
    }

    public static SimulationClockControl getInstance() {
        return instance;
    }

    private SimulationClockControl(CompetitionControlService competitionControl, TimeService timeService) {
        this.competitionControl = competitionControl;
        this.timeService = timeService;
        this.base = timeService.getBase();
        this.rate = timeService.getRate();
        this.modulo = timeService.getModulo();
        this.theTimer = new Timer();
        this.waitUntilStopSemaphores = Collections.synchronizedSet(new HashSet());
    }

    public void setStart(long start) {
        this.start = start;
        this.timeService.setStart(start);
    }

    public void scheduleTick() {
        long nextTick = this.computeNextTickTime();
        boolean success = false;
        while (!success) {
            try {
                this.theTimer.schedule((TimerTask)new TickAction(this), new Date(nextTick));
                success = true;
            }
            catch (IllegalStateException ise) {
                this.theTimer = new Timer();
            }
        }
    }

    public synchronized void complete() {
        if (this.state == Status.DELAYED) {
            if (this.pauseRequested) {
                this.state = Status.PAUSED;
                this.pauseRequested = false;
                return;
            }
            this.resume();
        }
        this.state = Status.COMPLETE;
    }

    public synchronized void stop() {
        this.state = Status.STOPPED;
        if (this.currentWatchdog != null) {
            this.currentWatchdog.cancel();
            this.currentWatchdog = null;
        }
        for (Semaphore sem : this.waitUntilStopSemaphores) {
            sem.release();
        }
        this.waitUntilStopSemaphores.clear();
    }

    public void waitUntilStop() {
        Status state = this.getState();
        if (state != Status.STOPPED) {
            Semaphore sem = new Semaphore(0);
            this.waitUntilStopSemaphores.add(sem);
            try {
                sem.acquire();
            }
            catch (InterruptedException e) {
                log.info((Object)"Who dares wake me up??", (Throwable)e);
            }
        }
    }

    public synchronized void waitForTick(int n) {
        while (this.nextTick < n) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void requestPause() {
        this.pauseRequested = true;
    }

    public synchronized void releasePause() {
        if (this.state != Status.PAUSED) {
            this.pauseRequested = false;
        } else {
            this.state = Status.COMPLETE;
            this.resume();
        }
    }

    private synchronized void notifyTick() {
        ++this.nextTick;
        this.notifyAll();
    }

    private synchronized void delayMaybe() {
        if (this.state == Status.CLEAR) {
            this.state = Status.DELAYED;
            this.competitionControl.pause();
        } else if (this.pauseRequested) {
            this.state = Status.PAUSED;
            this.competitionControl.pause();
            this.pauseRequested = false;
        } else if (this.state == Status.COMPLETE) {
            this.scheduleTick();
        }
    }

    private void resume() {
        long originalNextTick = this.computeNextTickTime();
        long actualNextTick = new Date().getTime() + 500L;
        this.start += actualNextTick - originalNextTick;
        this.timeService.setStart(this.start);
        this.competitionControl.resume(this.start);
        this.scheduleTick();
    }

    synchronized Status getState() {
        return this.state;
    }

    synchronized void setState(Status newState) {
        this.state = newState;
    }

    private long computeNextTickTime() {
        long current = new Date().getTime();
        if (current < this.start) {
            return this.start;
        }
        long simTime = this.timeService.getCurrentTime().getMillis();
        long nextSimTime = simTime + this.modulo;
        long nextTick = this.start + (nextSimTime - this.base) / this.rate;
        return nextTick;
    }

    private class WatchdogAction
    extends TimerTask {
        SimulationClockControl scc;

        WatchdogAction(SimulationClockControl scc) {
            this.scc = scc;
        }

        @Override
        public void run() {
            this.scc.delayMaybe();
            SimulationClockControl.this.currentWatchdog = null;
        }
    }

    private class TickAction
    extends TimerTask {
        SimulationClockControl scc;

        TickAction(SimulationClockControl scc) {
            this.scc = scc;
        }

        @Override
        public void run() {
            SimulationClockControl.this.timeService.updateTime();
            this.scc.setState(Status.CLEAR);
            long wdTime = SimulationClockControl.this.computeNextTickTime() - 200L;
            SimulationClockControl.this.currentWatchdog = new WatchdogAction(this.scc);
            SimulationClockControl.this.theTimer.schedule((TimerTask)SimulationClockControl.this.currentWatchdog, new Date(wdTime));
            this.scc.notifyTick();
        }
    }

    public static enum Status {
        CLEAR,
        COMPLETE,
        DELAYED,
        PAUSED,
        STOPPED;

    }
}

