/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherForecastPrediction;
import org.powertac.common.WeatherReport;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherForecastRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherService
extends TimeslotPhaseProcessor
implements InitializationService {
    private static Logger log = Logger.getLogger((String)WeatherService.class.getName());
    private boolean requestFailed = false;
    @ConfigurableValue(valueType="Integer", description="Timeslot interval to make requests")
    private int weatherReqInterval = 12;
    private int currentWeatherId = 1;
    @ConfigurableValue(valueType="String", description="Location of weather server")
    private String serverUrl = "http://tac06.cs.umn.edu:8080/powertac-weather-server/weatherSet/weatherRequest?id=0&setname=default&weather_days=1&weather_id=";
    @ConfigurableValue(valueType="Boolean", description="If network calls to weather server should block until finished")
    private boolean blocking = true;
    @ConfigurableValue(valueType="Integer", description="Length of forecasts (in hours)")
    private int forecastHorizon = 24;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private WeatherForecastRepo weatherForecastRepo;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private ServerConfiguration serverProps;

    public int getWeatherReqInterval() {
        return this.weatherReqInterval;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    public void activate(Instant time, int phaseNumber) {
        long msec;
        if (this.getWeatherReqInterval() > 24) {
            this.weatherReqInterval = 24;
        }
        if ((msec = time.getMillis()) % ((long)this.getWeatherReqInterval() * 3600000L) == 0L) {
            log.info((Object)("Timeslot " + this.timeslotRepo.currentTimeslot().getId() + " WeatherService reports time to make network request for weather data in blocking = " + this.isBlocking() + " mode."));
            try {
                this.webRequest(this.timeslotRepo.currentTimeslot(), 1);
                this.currentWeatherId += 2 * this.getWeatherReqInterval();
                this.requestFailed = false;
            }
            catch (Throwable e) {
                this.requestFailed = true;
            }
        } else {
            log.info((Object)"WeatherService reports not time to grab weather data.");
        }
        WeatherReport report = this.weatherReportRepo.currentWeatherReport();
        this.brokerProxyService.broadcastMessage((Object)report);
        WeatherForecast forecast = this.weatherForecastRepo.currentWeatherForecast();
        if (forecast == null) {
            log.error((Object)"null forecast");
        } else {
            this.brokerProxyService.broadcastMessage((Object)forecast);
        }
    }

    private boolean webRequest(Timeslot time, int randomSeed) {
        Timeslot currentTime = time;
        boolean readingForecast = false;
        ArrayList<Object> reportValues = new ArrayList<Object>();
        ArrayList<Object> forecastValues = new ArrayList<Object>();
        try {
            String tmpLine;
            URL url = new URL(this.getServerUrl() + this.currentWeatherId);
            URLConnection uRLConnection = url.openConnection();
            BufferedReader input = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while ((tmpLine = input.readLine()) != null) {
                if (tmpLine.trim().compareTo("---Forecast Data---") == 0) {
                    readingForecast = true;
                    continue;
                }
                tmpLine = tmpLine.replace("[", "");
                tmpLine = tmpLine.replace("]", "");
                String[] weatherValue = tmpLine.split(", ");
                for (int i = 0; i < weatherValue.length; ++i) {
                    weatherValue[i] = weatherValue[i].split(":")[1].trim();
                }
                if (!readingForecast) {
                    reportValues.add(weatherValue.clone());
                    continue;
                }
                forecastValues.add(weatherValue.clone());
            }
            input.close();
        }
        catch (Exception e) {
            log.error((Object)("Exception Raised during newtork call: " + e.toString()));
            return false;
        }
        for (String[] stringArray : reportValues) {
            WeatherReport newReport = new WeatherReport(currentTime, Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Double.parseDouble(stringArray[4]));
            this.weatherReportRepo.add(newReport);
            if (currentTime == null) {
                log.error((Object)"Null timeslot when adding reports to weatherReportRepo");
                continue;
            }
            currentTime = currentTime.getNext();
        }
        log.info((Object)(reportValues.size() + " WeatherReports fetched."));
        currentTime = time;
        for (int i = 1; i <= 2 * this.getWeatherReqInterval(); ++i) {
            ArrayList<WeatherForecastPrediction> currentPredictions = new ArrayList<WeatherForecastPrediction>();
            for (int j = 1; j <= this.getForecastHorizon(); ++j) {
                String[] stringArray = (String[])forecastValues.get(i + j);
                currentPredictions.add(new WeatherForecastPrediction(j, Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Double.parseDouble(stringArray[4])));
            }
            WeatherForecast newForecast = new WeatherForecast(currentTime, currentPredictions);
            this.weatherForecastRepo.add(newForecast);
            if (currentTime == null) {
                log.error((Object)"Null timeslot when adding forecasts to weatherForecastRepo");
                continue;
            }
            currentTime = currentTime.getNext();
        }
        log.info((Object)(forecastValues.size() + " WeatherForecasts fetched."));
        return true;
    }

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        super.init();
        this.serverProps.configureMe((Object)this);
        return "WeatherService";
    }
}

