/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.interfaces.BootstrapDataCollector;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.server.CompetitionControlService;
import org.powertac.server.LogService;
import org.powertac.server.ServerPropertiesService;
import org.powertac.server.TournamentSchedulerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service
public class CompetitionSetupService
implements CompetitionSetup {
    private static Logger log = Logger.getLogger(CompetitionSetupService.class);
    @Autowired
    private CompetitionControlService cc;
    @Autowired
    private BootstrapDataCollector defaultBroker;
    @Autowired
    private ServerPropertiesService serverProps;
    @Autowired
    private XMLMessageConverter messageConverter;
    @Autowired
    private LogService logService;
    @Autowired
    private TournamentSchedulerService tss;
    private Competition competition;
    private URL controllerURL;
    private Thread session = null;

    public void processCmdLine(String[] args) {
        if (args.length > 1) {
            this.processCli(args);
            this.waitForSession();
        } else if (args.length == 1) {
            this.processScript(args);
            this.waitForSession();
        } else {
            System.out.println("Server BootStrap");
            this.preGame();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private void waitForSession() {
        if (this.session != null) {
            try {
                this.session.join();
            }
            catch (InterruptedException e) {
                System.out.println("Error waiting for session completion: " + e.toString());
            }
        }
    }

    private void processCli(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec bootOutput = parser.accepts("boot").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec controllerOption = parser.accepts("control").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec gameId = parser.accepts("game-id").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec serverConfigUrl = parser.accepts("config").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec logSuffixOption = parser.accepts("log-suffix").withRequiredArg();
        parser.accepts("sim");
        ArgumentAcceptingOptionSpec bootData = parser.accepts("boot-data").withRequiredArg().ofType(URL.class);
        ArgumentAcceptingOptionSpec jmsUrl = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec brokerList = parser.accepts("brokers").withRequiredArg().withValuesSeparatedBy(',');
        OptionSet options = parser.parse(args);
        try {
            String logSuffix = (String)options.valueOf((OptionSpec)logSuffixOption);
            this.controllerURL = (URL)options.valueOf((OptionSpec)controllerOption);
            Integer game = (Integer)options.valueOf((OptionSpec)gameId);
            String serverConfig = (String)options.valueOf((OptionSpec)serverConfigUrl);
            if (this.controllerURL != null && game != null) {
                this.tss.setTournamentSchedulerUrl(this.controllerURL.toString());
                this.tss.setGameId(game);
            }
            if (serverConfig == null && this.controllerURL != null) {
                serverConfig = new URL(this.controllerURL, "server-config").toExternalForm();
            }
            if (options.has((OptionSpec)bootOutput)) {
                this.bootSession((String)options.valueOf((OptionSpec)bootOutput), serverConfig, logSuffix);
            } else if (options.has("sim")) {
                this.simSession(((URL)options.valueOf((OptionSpec)bootData)).toExternalForm(), serverConfig, (String)options.valueOf((OptionSpec)jmsUrl), logSuffix, options.valuesOf((OptionSpec)brokerList));
            } else {
                System.err.println("Must provide either --boot or --sim to run server");
                System.exit(1);
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
        catch (MalformedURLException e) {
            System.err.println("Cannot parse command line: " + e.toString());
            System.exit(1);
        }
    }

    private void setLogSuffix(String logSuffix, String defaultSuffix) throws IOException {
        if (logSuffix == null && this.controllerURL != null) {
            URL suffixUrl = new URL(this.controllerURL, "log-suffix");
            log.info((Object)("retrieving logSuffix from " + suffixUrl.toExternalForm()));
            InputStream stream = suffixUrl.openStream();
            byte[] buffer = new byte[64];
            int len = stream.read(buffer);
            if (len > 0) {
                logSuffix = new String(buffer, 0, len);
                log.info((Object)("log suffix " + logSuffix + " retrieved"));
            }
        }
        if (logSuffix == null) {
            logSuffix = defaultSuffix;
        }
        this.serverProps.setProperty("server.logfileSuffix", logSuffix);
    }

    private void processScript(String[] args) {
        System.out.println("old-style scriptfile interface");
        try {
            String input;
            BufferedReader config = new BufferedReader(new FileReader(args[0]));
            while ((input = config.readLine()) != null) {
                String[] tokens = input.split("\\s+");
                if ("bootstrap".equals(tokens[0])) {
                    if (tokens.length == 2 || tokens.length > 3) {
                        System.out.println("Bad input " + input);
                        continue;
                    }
                    if (tokens.length == 3 && "--config".equals(tokens[1])) {
                        this.setConfigMaybe(tokens[2]);
                    }
                    String bootstrapFilename = this.serverProps.getProperty("server.bootstrapDataFile", "/bd-noname.xml");
                    this.startBootSession(new File(bootstrapFilename));
                    continue;
                }
                if (!"sim".equals(tokens[0])) continue;
                int brokerIndex = 1;
                if (tokens.length > 2 && "--config".equals(tokens[1])) {
                    this.setConfigMaybe(tokens[2]);
                    brokerIndex = 3;
                }
                log.info((Object)"In Simulation mode!!!");
                String bootstrapFilename = this.serverProps.getProperty("server.bootstrapDataFile", "bd-noname.xml");
                File bootFile = new File(bootstrapFilename);
                if (!bootFile.canRead()) {
                    System.out.println("Cannot read bootstrap data file " + bootstrapFilename);
                    continue;
                }
                ArrayList<String> brokerList = new ArrayList<String>();
                for (int i = brokerIndex; i < tokens.length; ++i) {
                    brokerList.add(tokens[i]);
                }
                URL bootDataset = new URL("file:" + bootFile);
                this.startSimSession(brokerList, bootDataset);
            }
        }
        catch (FileNotFoundException fnf) {
            System.out.println("Cannot find file " + args[0]);
        }
        catch (IOException ioe) {
            System.out.println("Error reading file " + args[0]);
        }
        catch (ConfigurationException ce) {
            System.out.println("Error setting configuration: " + ce.toString());
        }
    }

    public String bootSession(String bootFilename, String config, String logSuffix) {
        String error = null;
        try {
            this.serverProps.recycle();
            this.setConfigMaybe(config);
            this.setLogSuffix(logSuffix, "boot");
            File bootFile = new File(bootFilename);
            if (!bootFile.getAbsoluteFile().getParentFile().canWrite()) {
                error = "Cannot write to bootstrap data file " + bootFilename;
                System.out.println(error);
            } else {
                this.startBootSession(bootFile);
            }
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println(error);
        }
        catch (IOException e) {
            error = "Error reading configuration";
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration";
        }
        return error;
    }

    public String simSession(String bootData, String config, String jmsUrl, String logfileSuffix, List<String> brokerUsernames) {
        String error = null;
        try {
            this.serverProps.recycle();
            this.setConfigMaybe(config);
            this.setLogSuffix(logfileSuffix, "sim");
            if (jmsUrl != null) {
                this.serverProps.setProperty("server.jmsManagementService.jmsBrokerUrl", jmsUrl);
            }
            if (bootData != null) {
                if (!bootData.contains(":")) {
                    bootData = "file:" + bootData;
                }
                this.startSimSession(brokerUsernames, new URL(bootData));
            } else if (this.controllerURL != null) {
                this.startSimSession(brokerUsernames, new URL(this.controllerURL, "bootstrap-data"));
            } else {
                error = "bootstrap data source not given";
                System.out.println(error);
            }
        }
        catch (MalformedURLException e) {
            error = "Malformed URL: " + e.toString();
            System.out.println(error);
        }
        catch (IOException e) {
            error = "Error reading configuration " + config;
        }
        catch (ConfigurationException e) {
            error = "Error setting configuration " + config;
        }
        return error;
    }

    private void setConfigMaybe(String config) throws ConfigurationException, IOException {
        if (config != null) {
            if (!config.contains(":")) {
                config = "file:" + config;
            }
            this.serverProps.setUserConfig(new URL(config));
        }
    }

    private void startBootSession(File bootstrapFile) throws IOException {
        final FileWriter bootWriter = new FileWriter(bootstrapFile);
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(new ArrayList<String>());
                CompetitionSetupService.this.preGame();
                CompetitionSetupService.this.cc.runOnce(true);
                CompetitionSetupService.this.saveBootstrapData(bootWriter);
            }
        };
        this.session.start();
    }

    private void startSimSession(final List<String> list, final URL bootDataset) {
        this.session = new Thread(){

            @Override
            public void run() {
                CompetitionSetupService.this.cc.setAuthorizedBrokerList(list);
                if (CompetitionSetupService.this.preGame(bootDataset)) {
                    CompetitionSetupService.this.cc.setBootstrapDataset(CompetitionSetupService.this.processBootDataset(bootDataset));
                    CompetitionSetupService.this.cc.runOnce(false);
                }
            }
        };
        this.session.start();
    }

    public void preGame() {
        String suffix = this.serverProps.getProperty("server.logfileSuffix", "x");
        this.logService.startLog(suffix);
        log.info((Object)"preGame() - start");
        this.competition = Competition.newInstance((String)"defaultCompetition");
        log.info((Object)"pre-game initialization");
        this.configureCompetition(this.competition);
        List repos = SpringApplicationContext.listBeansOfType(DomainRepo.class);
        log.debug((Object)("found " + repos.size() + " repos"));
        for (DomainRepo repo : repos) {
            repo.recycle();
        }
        List initializers = SpringApplicationContext.listBeansOfType(InitializationService.class);
        log.debug((Object)("found " + initializers.size() + " initializers"));
        for (InitializationService init : initializers) {
            init.setDefaults();
        }
    }

    private void configureCompetition(Competition competition) {
        this.serverProps.configureMe(competition);
    }

    public boolean preGame(URL bootFile) {
        log.info((Object)"preGame(File) - start");
        this.preGame();
        Competition bootstrapCompetition = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/config/competition");
            NodeList nodes = (NodeList)exp.evaluate(new InputSource(bootFile.openStream()), XPathConstants.NODESET);
            String xml = this.nodeToString(nodes.item(0));
            bootstrapCompetition = (Competition)this.messageConverter.fromXML(xml);
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("preGame: Error reading boot dataset: " + xee.toString()));
            return false;
        }
        catch (IOException ioe) {
            log.error((Object)("preGame: Error opening file " + bootFile + ": " + ioe.toString()));
        }
        Competition.currentCompetition().update(bootstrapCompetition);
        return true;
    }

    void saveBootstrapData(Writer datasetWriter) {
        BufferedWriter output = new BufferedWriter(datasetWriter);
        List data = this.defaultBroker.collectBootstrapData(this.competition.getBootstrapTimeslotCount());
        try {
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            output.newLine();
            output.write("<powertac-bootstrap-data>");
            output.newLine();
            output.write("<config>");
            output.newLine();
            output.write(this.messageConverter.toXML((Object)this.competition));
            output.newLine();
            output.write("</config>");
            output.newLine();
            output.write("<bootstrap>");
            output.newLine();
            for (Object item : data) {
                output.write(this.messageConverter.toXML(item));
                output.newLine();
            }
            output.write("</bootstrap>");
            output.newLine();
            output.write("</powertac-bootstrap-data>");
            output.newLine();
            output.close();
        }
        catch (IOException ioe) {
            log.error((Object)("Error writing bootstrap file: " + ioe.toString()));
        }
    }

    private ArrayList<Object> processBootDataset(URL bootDataset) {
        ArrayList<Object> result = new ArrayList<Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            InputSource source = new InputSource(bootDataset.openStream());
            XPathExpression exp = xPath.compile("/powertac-bootstrap-data/bootstrap/*");
            NodeList nodes = (NodeList)exp.evaluate(source, XPathConstants.NODESET);
            log.info((Object)("Found " + nodes.getLength() + " bootstrap nodes"));
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xml = this.nodeToString(nodes.item(i));
                Object msg = this.messageConverter.fromXML(xml);
                result.add(msg);
            }
        }
        catch (XPathExpressionException xee) {
            log.error((Object)("runOnce: Error reading config file: " + xee.toString()));
        }
        catch (IOException ioe) {
            log.error((Object)("runOnce: reset fault: " + ioe.toString()));
        }
        return result;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error((Object)("nodeToString Transformer Exception " + te.toString()));
        }
        String result = sw.toString();
        return result;
    }
}

