/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.ServerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.stereotype.Service;

@Service
public class JmsManagementService {
    private static Logger log = Logger.getLogger(JmsManagementService.class);
    @Resource(name="jmsFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private Executor taskExecutor;
    @Autowired
    private ServerConfiguration serverPropertiesService;
    private Map<MessageListener, AbstractMessageListenerContainer> listenerContainerMap = new HashMap<MessageListener, AbstractMessageListenerContainer>();
    private boolean servingJms = true;
    private String jmsBrokerUrl = "tcp://localhost:61616";
    private String jmsBrokerName = "simJmsProvider";

    public void initializeServerQueue(String serverQueueName) {
        this.createQueue(serverQueueName);
    }

    public void start() {
        this.serverPropertiesService.configureMe((Object)this);
        if (this.isServingJms()) {
            this.startProvider();
        }
        this.initializeClientInterface();
    }

    public void startProvider() {
        BrokerService brokerService = BrokerRegistry.getInstance().lookup(this.getJmsBrokerName());
        if (brokerService != null) {
            log.info((Object)"JMS Server is already started.");
            return;
        }
        brokerService = new BrokerService();
        try {
            brokerService.setBrokerName(this.getJmsBrokerName());
            brokerService.setPersistent(false);
            brokerService.addConnector(this.getJmsBrokerUrl());
            brokerService.start();
            brokerService.waitUntilStarted();
        }
        catch (Exception e) {
            log.error((Object)"Failed to start JMS Server", (Throwable)e);
        }
    }

    public void stop() {
        this.unregisterAllMessageListeners();
        if (this.isServingJms()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.info((Object)"Hey, why did you bother me??", (Throwable)e);
            }
            this.stopProvider();
        }
    }

    public void initializeClientInterface() {
        PooledConnectionFactory pooledConnectionFactory;
        if (this.connectionFactory instanceof PooledConnectionFactory && (pooledConnectionFactory = (PooledConnectionFactory)this.connectionFactory).getConnectionFactory() instanceof ActiveMQConnectionFactory) {
            ActiveMQConnectionFactory amqConnectionFactory = (ActiveMQConnectionFactory)pooledConnectionFactory.getConnectionFactory();
            amqConnectionFactory.setBrokerURL(this.getJmsBrokerUrl());
        }
    }

    public void stopProvider() {
        BrokerService brokerService = BrokerRegistry.getInstance().lookup(this.getJmsBrokerName());
        try {
            if (brokerService != null) {
                brokerService.stop();
                brokerService.waitUntilStopped();
            } else {
                log.info((Object)"Could not stop ActiveMQ broker.  It was never started");
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to stop JMS Server", (Throwable)e);
        }
    }

    public Queue createQueue(String queueName) {
        Queue queue = null;
        try {
            Connection connection = this.connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            queue = session.createQueue(queueName);
        }
        catch (JMSException e) {
            log.error((Object)("Failed to create queue " + queueName), (Throwable)e);
        }
        return queue;
    }

    public void registerMessageListener(String destinationName, MessageListener listener) {
        log.info((Object)("registerMessageListener(" + destinationName + ", " + listener + ")"));
        DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
        container.setConnectionFactory(this.connectionFactory);
        container.setDestinationName(destinationName);
        container.setMessageListener((Object)listener);
        container.setTaskExecutor(this.taskExecutor);
        container.afterPropertiesSet();
        container.start();
        this.listenerContainerMap.put(listener, (AbstractMessageListenerContainer)container);
    }

    public void unregisterMessageListener(MessageListener listener) {
        DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)this.listenerContainerMap.get(listener);
        if (container != null) {
            container.shutdown();
        }
        this.listenerContainerMap.remove(listener);
    }

    public void unregisterAllMessageListeners() {
        for (Map.Entry<MessageListener, AbstractMessageListenerContainer> entry : this.listenerContainerMap.entrySet()) {
            this.unregisterMessageListener(entry.getKey());
        }
    }

    public boolean isServingJms() {
        return this.servingJms;
    }

    public boolean getServingJms() {
        return this.servingJms;
    }

    @ConfigurableValue(valueType="Boolean", description="Flag to indicate if this sim server is also the JMS provider")
    public void setServingJms(boolean servingJms) {
        this.servingJms = servingJms;
    }

    public String getJmsBrokerUrl() {
        return this.jmsBrokerUrl;
    }

    @ConfigurableValue(valueType="String", description="JMS broker URL to serve and/or use by sim server")
    public void setJmsBrokerUrl(String jmsBrokerUrl) {
        this.jmsBrokerUrl = jmsBrokerUrl;
    }

    public String getJmsBrokerName() {
        return this.jmsBrokerName;
    }

    @ConfigurableValue(valueType="String", description="JMS broker name for looking up JMS provider")
    public void setJmsBrokerName(String jmsBrokerName) {
        this.jmsBrokerName = jmsBrokerName;
    }
}

